/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.saml.v2.assertion;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclType;
import org.picketlink.identity.federation.saml.v2.assertion.URIType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthnContextType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<URI> authenticatingAuthority = new LinkedHashSet<URI>();
    private AuthnContextTypeSequence sequence;
    private final Set<URIType> URITypes = new HashSet<URIType>();

    public void addAuthenticatingAuthority(URI aa) {
        this.authenticatingAuthority.add(aa);
    }

    public void addAuthenticatingAuthority(URI[] aas) {
        this.authenticatingAuthority.addAll(Arrays.asList(aas));
    }

    public void removeAuthenticatingAuthority(URI aa) {
        this.authenticatingAuthority.remove(aa);
    }

    public Set<URI> getAuthenticatingAuthority() {
        return Collections.unmodifiableSet(this.authenticatingAuthority);
    }

    public AuthnContextTypeSequence getSequence() {
        return this.sequence;
    }

    public void setSequence(AuthnContextTypeSequence sequence) {
        this.sequence = sequence;
    }

    public void addURIType(URIType aa) {
        this.URITypes.add(aa);
    }

    public void addURIType(URIType[] aas) {
        this.URITypes.addAll(Arrays.asList(aas));
    }

    public Set<URIType> getURIType() {
        return Collections.unmodifiableSet(this.URITypes);
    }

    public void removeURIType(URIType aa) {
        this.URITypes.remove(aa);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthnContextTypeSequence
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AuthnContextClassRefType classRef;
        private AuthnContextDeclType authnContextDecl;
        private final Set<URIType> URITypes = new HashSet<URIType>();

        public AuthnContextClassRefType getClassRef() {
            return this.classRef;
        }

        public void setClassRef(AuthnContextClassRefType classRef) {
            this.classRef = classRef;
        }

        public void addURIType(URIType aa) {
            this.URITypes.add(aa);
        }

        public void removeURIType(URIType aa) {
            this.URITypes.remove(aa);
        }

        public void addURIType(URIType[] aas) {
            this.URITypes.addAll(Arrays.asList(aas));
        }

        public Set<URIType> getURIType() {
            return Collections.unmodifiableSet(this.URITypes);
        }

        public AuthnContextDeclType getAuthnContextDecl() {
            return this.authnContextDecl;
        }

        public void setAuthnContextDecl(AuthnContextDeclType authnContextDecl) {
            this.authnContextDecl = authnContextDecl;
        }
    }
}

