/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.KeyPair;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SAML2SignatureGenerationHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2SignatureGenerationHandler.class);
    private final boolean trace = log.isTraceEnabled();

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document samlDocument = response.getResultingDocument();
        if (samlDocument == null && this.trace) {
            log.trace((Object)"No document generated in the handler chain. Cannot generate signature");
            return;
        }
        KeyPair keypair = (KeyPair)this.handlerChainConfig.getParameter("KEYPAIR");
        if (keypair == null) {
            log.error((Object)"Key Pair cannot be found");
            throw new ProcessingException("PL00092: Null Value:KeyPair not found");
        }
        this.sign(samlDocument, keypair);
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document responseDocument = response.getResultingDocument();
        if (responseDocument == null) {
            if (this.trace) {
                log.trace((Object)"handleRequestType:No response document found");
            }
            return;
        }
        KeyPair keypair = (KeyPair)this.handlerChainConfig.getParameter("KEYPAIR");
        this.sign(responseDocument, keypair);
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document responseDocument = response.getResultingDocument();
        if (responseDocument == null) {
            if (this.trace) {
                log.trace((Object)"handleStatusResponseType:No response document found");
            }
            return;
        }
        KeyPair keypair = (KeyPair)this.handlerChainConfig.getParameter("KEYPAIR");
        this.sign(responseDocument, keypair);
    }

    private void sign(Document samlDocument, KeyPair keypair) throws ProcessingException {
        SAML2Signature samlSignature = new SAML2Signature();
        Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
        samlSignature.setNextSibling(nextSibling);
        samlSignature.signSAMLDocument(samlDocument, keypair);
    }
}

