/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationAddMessage
extends PacketImpl {
    private static final Logger log = Logger.getLogger(ReplicationAddMessage.class);
    private long id;
    private byte journalID;
    private boolean isUpdate;
    private byte recordType;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationAddMessage() {
        super((byte)91);
    }

    public ReplicationAddMessage(byte journalID, boolean isUpdate, long id, byte recordType, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.isUpdate = isUpdate;
        this.id = id;
        this.recordType = recordType;
        this.encodingData = encodingData;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.isUpdate);
        buffer.writeLong(this.id);
        buffer.writeByte(this.recordType);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.isUpdate = buffer.readBoolean();
        this.id = buffer.readLong();
        this.recordType = buffer.readByte();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }
}

