/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.utils.IDGenerator;

public class TimeAndCounterIDGenerator
implements IDGenerator {
    private static final int BITS_TO_MOVE = 20;
    public static final long MASK_TIME = 0x7FFFFFFFFF0L;
    public static final long ID_MASK = 0xFFFFFFL;
    private static final long TIME_ID_MASK = 0x7FFFFFFFFF000000L;
    private final AtomicLong counter = new AtomicLong(0L);
    private volatile boolean wrapped = false;
    private volatile long tmMark;

    public TimeAndCounterIDGenerator() {
        this.refresh();
    }

    public long generateID() {
        long idReturn = this.counter.incrementAndGet();
        if ((idReturn & 0xFFFFFFL) == 0L) {
            long timePortion = idReturn & 0x7FFFFFFFFF000000L;
            if (timePortion >= this.newTM()) {
                this.wrapped = true;
            } else {
                this.tmMark = timePortion;
            }
        }
        if (this.wrapped) {
            throw new IllegalStateException("The IDGenerator is being overlaped, and it needs revision as the system generated more than 16777215 ids per 16 milliseconds which exceeded the IDgenerator limit");
        }
        return idReturn;
    }

    public long getCurrentID() {
        return this.counter.get();
    }

    public long getInternalTimeMark() {
        return this.tmMark;
    }

    public void setInternalID(long id) {
        this.counter.set(this.tmMark | id);
    }

    public void setInternalDate(long date) {
        this.tmMark = (date & 0x7FFFFFFFFF0L) << 20;
        this.counter.set(this.tmMark);
    }

    public synchronized void refresh() {
        long oldTm = this.tmMark;
        long newTm = this.newTM();
        while (newTm <= oldTm) {
            newTm = this.newTM();
        }
        this.tmMark = newTm;
        this.counter.set(this.tmMark);
    }

    public String toString() {
        long currentCounter = this.counter.get();
        return "SequenceGenerator(tmMark=" + this.hex(this.tmMark) + ", CurrentCounter = " + currentCounter + ", HexCurrentCounter = " + this.hex(currentCounter) + ")";
    }

    private long newTM() {
        return (System.currentTimeMillis() & 0x7FFFFFFFFF0L) << 20;
    }

    private String hex(long x) {
        return String.format("%1$X", x);
    }
}

