/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.naming.remote.protocol.ProtocolCommand;
import org.jboss.naming.remote.protocol.v1.ProtocolIoFuture;
import org.jboss.naming.remote.protocol.v1.ReadUtil;

abstract class BaseProtocolCommand<T>
implements ProtocolCommand<T> {
    public static final int DEFAULT_TIMEOUT = 10;
    private int nextCorrelationId = 1;
    private final Map<Integer, ProtocolIoFuture> requests = new HashMap<Integer, ProtocolIoFuture>();
    private final byte commandId;

    protected BaseProtocolCommand(byte commandId) {
        this.commandId = commandId;
    }

    @Override
    public byte getCommandId() {
        return this.commandId;
    }

    protected <T> void readResult(int correlationId, DataInput input, ValueReader<T> valueReader) throws IOException {
        ProtocolIoFuture<?> future = this.getFuture(correlationId);
        try {
            byte outcome = input.readByte();
            if (outcome == 0) {
                valueReader.read(input, future);
            } else if (outcome == 1) {
                byte parameterType = input.readByte();
                if (parameterType != 2) {
                    throw new IOException("Unexpected response parameter received.");
                }
                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                Exception exception = unmarshaller.readObject(Exception.class);
                future.setHeldException(exception);
            } else {
                future.setException(new IOException("Outcome not understood"));
            }
        }
        catch (ClassCastException e) {
            future.setException(new IOException(e));
        }
        catch (ClassNotFoundException e) {
            future.setException(new IOException(e));
        }
        catch (IOException e) {
            future.setException(e);
        }
    }

    private synchronized int getNextCorrelationId() {
        int next;
        if ((next = this.nextCorrelationId++) < 0) {
            this.nextCorrelationId = 2;
            next = 1;
        }
        return next;
    }

    protected synchronized int reserveNextCorrelationId(ProtocolIoFuture<?> future) {
        Integer next = this.getNextCorrelationId();
        while (this.requests.containsKey(next)) {
            next = this.getNextCorrelationId();
        }
        this.requests.put(next, future);
        return next;
    }

    private synchronized ProtocolIoFuture<?> getFuture(int correlationId) {
        return this.requests.get(correlationId);
    }

    protected synchronized void releaseCorrelationId(int correlationId) {
        this.requests.remove(correlationId);
    }

    protected class MarshalledValueReader<T>
    implements ValueReader<T> {
        private final byte expectedType;

        public MarshalledValueReader(byte expectedType) {
            this.expectedType = expectedType;
        }

        public byte getExpectedType() {
            return this.expectedType;
        }

        @Override
        public void read(DataInput input, ProtocolIoFuture<T> future) throws IOException {
            if (this.expectedType != 3) {
                byte parameterType = input.readByte();
                if (parameterType != this.expectedType) {
                    throw new IOException("Unexpected response parameter received.");
                }
                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                try {
                    future.setResult(unmarshaller.readObject());
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
                catch (ClassCastException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    protected static interface ValueReader<T> {
        public void read(DataInput var1, ProtocolIoFuture<T> var2) throws IOException;
    }
}

