/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.xnio.Cancellable;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

public abstract class AbstractIoFuture<T>
implements IoFuture<T> {
    private static final Logger log = Logger.getLogger("org.xnio.future");
    private final Object lock = new Object();
    private IoFuture.Status status = IoFuture.Status.WAITING;
    private Object result;
    private List<Runnable> notifierList;
    private List<Cancellable> cancellables;
    private static final List<Cancellable> CANCEL_REQUESTED = Collections.emptyList();

    protected AbstractIoFuture() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status await() {
        Object object = this.lock;
        synchronized (object) {
            boolean intr = Thread.interrupted();
            try {
                while (this.status == IoFuture.Status.WAITING) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status await(long time, TimeUnit timeUnit) {
        if (time < 0L) {
            time = 0L;
        }
        long duration = timeUnit.toNanos(time);
        long now = System.nanoTime();
        Object object = this.lock;
        synchronized (object) {
            IoFuture.Status status;
            boolean intr = Thread.interrupted();
            try {
                long waitTime;
                while ((status = this.status) == IoFuture.Status.WAITING && (waitTime = duration / 1000000L) > 0L) {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                    finally {
                        long l = now;
                        now = System.nanoTime();
                        duration += l - now;
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status awaitInterruptibly() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.status == IoFuture.Status.WAITING) {
                this.lock.wait();
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
        if (time < 0L) {
            time = 0L;
        }
        long duration = timeUnit.toNanos(time);
        long now = System.nanoTime();
        Object object = this.lock;
        synchronized (object) {
            long waitTime;
            IoFuture.Status status;
            while ((status = this.status) == IoFuture.Status.WAITING && (waitTime = duration / 1000000L) > 0L) {
                this.lock.wait(waitTime);
                long l = now;
                now = System.nanoTime();
                duration += l - now;
            }
            return status;
        }
    }

    @Override
    public T get() throws IOException, CancellationException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.await()) {
                case DONE: {
                    return (T)this.result;
                }
                case FAILED: {
                    throw (IOException)this.result;
                }
                case CANCELLED: {
                    throw new CancellationException("Operation was cancelled");
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.status));
        }
    }

    @Override
    public T getInterruptibly() throws IOException, InterruptedException, CancellationException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.awaitInterruptibly()) {
                case DONE: {
                    return (T)this.result;
                }
                case FAILED: {
                    throw (IOException)this.result;
                }
                case CANCELLED: {
                    throw new CancellationException("Operation was cancelled");
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.status));
        }
    }

    @Override
    public IOException getException() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.FAILED) {
                return (IOException)this.result;
            }
            throw new IllegalStateException("getException() when state is not FAILED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> IoFuture<T> addNotifier(final IoFuture.Notifier<? super T, A> notifier, final A attachment) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    notifier.notify(AbstractIoFuture.this, attachment);
                }
                catch (Throwable t) {
                    log.warnf(t, "Running notifier failed", new Object[0]);
                }
            }
        };
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                if (this.notifierList == null) {
                    this.notifierList = new ArrayList<Runnable>();
                }
                this.notifierList.add(runnable);
                return this;
            }
        }
        this.runNotifier(runnable);
        return this;
    }

    private void runAllNotifiers() {
        if (this.notifierList != null) {
            for (Runnable runnable : this.notifierList) {
                this.runNotifier(runnable);
            }
            this.notifierList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setException(IOException exception) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.FAILED;
                this.result = exception;
                this.cancellables = null;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setResult(T result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.DONE;
                this.result = result;
                this.cancellables = null;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setCancelled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.CANCELLED;
                this.cancellables = null;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture<T> cancel() {
        List<Cancellable> cancellables;
        Object object = this.lock;
        synchronized (object) {
            cancellables = this.cancellables;
            if (cancellables == null || cancellables == CANCEL_REQUESTED) {
                return this;
            }
            this.cancellables = CANCEL_REQUESTED;
        }
        for (Cancellable cancellable : cancellables) {
            cancellable.cancel();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCancelHandler(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case CANCELLED: {
                    break;
                }
                case WAITING: {
                    List<Cancellable> cancellables = this.cancellables;
                    if (cancellables == CANCEL_REQUESTED) break;
                    (cancellables == null ? (this.cancellables = new ArrayList<Cancellable>()) : cancellables).add(cancellable);
                }
                default: {
                    return;
                }
            }
        }
        cancellable.cancel();
    }

    protected void runNotifier(Runnable runnable) {
        this.getNotifierExecutor().execute(runnable);
    }

    protected Executor getNotifierExecutor() {
        return IoUtils.directExecutor();
    }
}

