/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.mapping.UDDIServiceCache;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.Result;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UDDIClientSubscriptionListenerService", endpointInterface="org.uddi.v3_service.UDDISubscriptionListenerPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIClientSubscriptionListenerImpl
implements UDDISubscriptionListenerPortType {
    private static final long serialVersionUID = 100157393329807903L;
    private static Log logger = LogFactory.getLog(UDDIClientSubscriptionListenerImpl.class);
    private static Map<String, UDDIServiceCache> serviceCacheMap = new ConcurrentHashMap<String, UDDIServiceCache>();

    public UDDIClientSubscriptionListenerImpl(String bindingKey, UDDIServiceCache serviceCache) {
        serviceCacheMap.put(bindingKey, serviceCache);
    }

    public UDDIClientSubscriptionListenerImpl() {
    }

    public static Map<String, UDDIServiceCache> getServiceCacheMap() {
        return serviceCacheMap;
    }

    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{body.getClass()});
            Marshaller marshaller = context.createMarshaller();
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)body, (Writer)sw);
            logger.debug((Object)("Notification received by UDDISubscriptionListenerService : " + sw.toString()));
            String bindingKey = body.getSubscriptionResultsList().getSubscription().getBindingKey();
            if (serviceCacheMap.containsKey(bindingKey)) {
                UDDIServiceCache serviceCache = serviceCacheMap.get(bindingKey);
                serviceCache.removeAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DispositionReport dr = new DispositionReport();
        Result res = new Result();
        dr.getResult().add(res);
        return dr;
    }
}

