/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.watch;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        Args cmd = new Args();
        JCommander.newBuilder().addObject((Object)cmd).build().parse(args);
        CountDownLatch latch = new CountDownLatch(cmd.maxEvents);
        ByteSequence key = ByteSequence.from((String)cmd.key, (Charset)StandardCharsets.UTF_8);
        List endpoints = Util.toURIs((Collection)cmd.endpoints);
        Watch.Listener listener = Watch.listener(response -> {
            LOGGER.info("Watching for key={}", (Object)cmd.key);
            for (WatchEvent event : response.getEvents()) {
                LOGGER.info("type={}, key={}, value={}", new Object[]{event.getEventType(), Optional.ofNullable(event.getKeyValue().getKey()).map(bs -> bs.toString(StandardCharsets.UTF_8)).orElse(""), Optional.ofNullable(event.getKeyValue().getValue()).map(bs -> bs.toString(StandardCharsets.UTF_8)).orElse("")});
            }
            latch.countDown();
        });
        try (Client client = Client.builder().endpoints((Collection)endpoints).build();
             Watch watch = client.getWatchClient();
             Watch.Watcher watcher = watch.watch(key, listener);){
            latch.await();
        }
        catch (Exception e) {
            LOGGER.error("Watching Error {}", (Throwable)e);
            System.exit(1);
        }
    }

    public static class Args {
        @Parameter(required=true, names={"-e", "--endpoints"}, description="the etcd endpoints")
        private List<String> endpoints = new ArrayList<String>();
        @Parameter(required=true, names={"-k", "--key"}, description="the key to watch")
        private String key;
        @Parameter(names={"-m", "--max-events"}, description="the maximum number of events to receive")
        private Integer maxEvents = Integer.MAX_VALUE;
    }
}

