/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeFuture;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Fallback;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

class FallbackExecutor
extends PolicyExecutor<Fallback> {
    FallbackExecutor(Fallback fallback, AbstractExecution execution) {
        super(fallback, execution);
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        try {
            return result.withResult(((Fallback)this.policy).apply(result.getResult(), result.getFailure(), this.execution.copy()));
        }
        catch (Exception e) {
            return ExecutionResult.failure(e);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult> onFailureAsync(ExecutionResult result, Scheduler scheduler, FailsafeFuture<Object> future) {
        if (!((Fallback)this.policy).isAsync()) {
            return CompletableFuture.completedFuture(this.onFailure(result));
        }
        CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
        Callable<Object> callable = () -> promise.complete(this.onFailure(result));
        try {
            future.inject(scheduler.schedule(callable, result.getWaitNanos(), TimeUnit.NANOSECONDS));
        }
        catch (Throwable t) {
            promise.completeExceptionally(t);
        }
        return promise;
    }
}

