package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.MaintenanceGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: rpc.proto")
public final class VertxMaintenanceGrpc {
    private VertxMaintenanceGrpc() {}

    public static MaintenanceVertxStub newVertxStub(io.grpc.Channel channel) {
        return new MaintenanceVertxStub(channel);
    }

    
    public static final class MaintenanceVertxStub extends io.grpc.stub.AbstractStub<MaintenanceVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private MaintenanceGrpc.MaintenanceStub delegateStub;

        private MaintenanceVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = MaintenanceGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private MaintenanceVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = MaintenanceGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected MaintenanceVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new MaintenanceVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AlarmResponse> alarm(io.etcd.jetcd.api.AlarmRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::alarm);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.StatusResponse> status(io.etcd.jetcd.api.StatusRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::status);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.DefragmentResponse> defragment(io.etcd.jetcd.api.DefragmentRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::defragment);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.HashResponse> hash(io.etcd.jetcd.api.HashRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::hash);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.HashKVResponse> hashKV(io.etcd.jetcd.api.HashKVRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::hashKV);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MoveLeaderResponse> moveLeader(io.etcd.jetcd.api.MoveLeaderRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::moveLeader);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.SnapshotResponse> snapshot(io.etcd.jetcd.api.SnapshotRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToMany(ctx, request, delegateStub::snapshot);
        }

        public io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.SnapshotResponse> snapshotWithHandler(io.etcd.jetcd.api.SnapshotRequest request, io.vertx.core.Handler<io.etcd.jetcd.api.SnapshotResponse> handler, io.vertx.core.Handler<java.lang.Void> endHandler, io.vertx.core.Handler<java.lang.Throwable> exceptionHandler) {
            return io.vertx.grpc.stub.ClientCalls.oneToMany(ctx, request, delegateStub::snapshot, handler, endHandler, exceptionHandler);
        }

    }

    
    public static abstract class MaintenanceVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public MaintenanceVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AlarmResponse> alarm(io.etcd.jetcd.api.AlarmRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.StatusResponse> status(io.etcd.jetcd.api.StatusRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.DefragmentResponse> defragment(io.etcd.jetcd.api.DefragmentRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.HashResponse> hash(io.etcd.jetcd.api.HashRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.HashKVResponse> hashKV(io.etcd.jetcd.api.HashKVRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MoveLeaderResponse> moveLeader(io.etcd.jetcd.api.MoveLeaderRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public void snapshot(io.etcd.jetcd.api.SnapshotRequest request, io.vertx.core.streams.WriteStream<io.etcd.jetcd.api.SnapshotResponse> response) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getAlarmMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AlarmRequest,
                                            io.etcd.jetcd.api.AlarmResponse>(
                                            this, METHODID_ALARM, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getStatusMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.StatusRequest,
                                            io.etcd.jetcd.api.StatusResponse>(
                                            this, METHODID_STATUS, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getDefragmentMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.DefragmentRequest,
                                            io.etcd.jetcd.api.DefragmentResponse>(
                                            this, METHODID_DEFRAGMENT, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getHashMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.HashRequest,
                                            io.etcd.jetcd.api.HashResponse>(
                                            this, METHODID_HASH, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getHashKVMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.HashKVRequest,
                                            io.etcd.jetcd.api.HashKVResponse>(
                                            this, METHODID_HASH_KV, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getSnapshotMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.SnapshotRequest,
                                            io.etcd.jetcd.api.SnapshotResponse>(
                                            this, METHODID_SNAPSHOT, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.MaintenanceGrpc.getMoveLeaderMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.MoveLeaderRequest,
                                            io.etcd.jetcd.api.MoveLeaderResponse>(
                                            this, METHODID_MOVE_LEADER, compression)))
                    .build();
        }
    }

    private static final int METHODID_ALARM = 0;
    private static final int METHODID_STATUS = 1;
    private static final int METHODID_DEFRAGMENT = 2;
    private static final int METHODID_HASH = 3;
    private static final int METHODID_HASH_KV = 4;
    private static final int METHODID_SNAPSHOT = 5;
    private static final int METHODID_MOVE_LEADER = 6;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final MaintenanceVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(MaintenanceVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_ALARM:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AlarmRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AlarmResponse>) responseObserver,
                            compression,
                            serviceImpl::alarm);
                    break;
                case METHODID_STATUS:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.StatusRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.StatusResponse>) responseObserver,
                            compression,
                            serviceImpl::status);
                    break;
                case METHODID_DEFRAGMENT:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.DefragmentRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.DefragmentResponse>) responseObserver,
                            compression,
                            serviceImpl::defragment);
                    break;
                case METHODID_HASH:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.HashRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.HashResponse>) responseObserver,
                            compression,
                            serviceImpl::hash);
                    break;
                case METHODID_HASH_KV:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.HashKVRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.HashKVResponse>) responseObserver,
                            compression,
                            serviceImpl::hashKV);
                    break;
                case METHODID_SNAPSHOT:
                    io.vertx.grpc.stub.ServerCalls.oneToMany(
                            (io.etcd.jetcd.api.SnapshotRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.SnapshotResponse>) responseObserver,
                            compression,
                            serviceImpl::snapshot);
                    break;
                case METHODID_MOVE_LEADER:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.MoveLeaderRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.MoveLeaderResponse>) responseObserver,
                            compression,
                            serviceImpl::moveLeader);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
