package io.etcd.jetcd.api;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The election service exposes client-side election facilities as a gRPC interface.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.68.1)",
    comments = "Source: election.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class ElectionGrpc {

  private ElectionGrpc() {}

  public static final java.lang.String SERVICE_NAME = "v3electionpb.Election";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.CampaignRequest,
      io.etcd.jetcd.api.CampaignResponse> getCampaignMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Campaign",
      requestType = io.etcd.jetcd.api.CampaignRequest.class,
      responseType = io.etcd.jetcd.api.CampaignResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.CampaignRequest,
      io.etcd.jetcd.api.CampaignResponse> getCampaignMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.CampaignRequest, io.etcd.jetcd.api.CampaignResponse> getCampaignMethod;
    if ((getCampaignMethod = ElectionGrpc.getCampaignMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getCampaignMethod = ElectionGrpc.getCampaignMethod) == null) {
          ElectionGrpc.getCampaignMethod = getCampaignMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.CampaignRequest, io.etcd.jetcd.api.CampaignResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Campaign"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.CampaignRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.CampaignResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Campaign"))
              .build();
        }
      }
    }
    return getCampaignMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.ProclaimRequest,
      io.etcd.jetcd.api.ProclaimResponse> getProclaimMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Proclaim",
      requestType = io.etcd.jetcd.api.ProclaimRequest.class,
      responseType = io.etcd.jetcd.api.ProclaimResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.ProclaimRequest,
      io.etcd.jetcd.api.ProclaimResponse> getProclaimMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.ProclaimRequest, io.etcd.jetcd.api.ProclaimResponse> getProclaimMethod;
    if ((getProclaimMethod = ElectionGrpc.getProclaimMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getProclaimMethod = ElectionGrpc.getProclaimMethod) == null) {
          ElectionGrpc.getProclaimMethod = getProclaimMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.ProclaimRequest, io.etcd.jetcd.api.ProclaimResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Proclaim"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.ProclaimRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.ProclaimResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Proclaim"))
              .build();
        }
      }
    }
    return getProclaimMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.LeaderRequest,
      io.etcd.jetcd.api.LeaderResponse> getLeaderMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Leader",
      requestType = io.etcd.jetcd.api.LeaderRequest.class,
      responseType = io.etcd.jetcd.api.LeaderResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.LeaderRequest,
      io.etcd.jetcd.api.LeaderResponse> getLeaderMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.LeaderRequest, io.etcd.jetcd.api.LeaderResponse> getLeaderMethod;
    if ((getLeaderMethod = ElectionGrpc.getLeaderMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getLeaderMethod = ElectionGrpc.getLeaderMethod) == null) {
          ElectionGrpc.getLeaderMethod = getLeaderMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.LeaderRequest, io.etcd.jetcd.api.LeaderResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Leader"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.LeaderRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.LeaderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Leader"))
              .build();
        }
      }
    }
    return getLeaderMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.LeaderRequest,
      io.etcd.jetcd.api.LeaderResponse> getObserveMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Observe",
      requestType = io.etcd.jetcd.api.LeaderRequest.class,
      responseType = io.etcd.jetcd.api.LeaderResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.LeaderRequest,
      io.etcd.jetcd.api.LeaderResponse> getObserveMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.LeaderRequest, io.etcd.jetcd.api.LeaderResponse> getObserveMethod;
    if ((getObserveMethod = ElectionGrpc.getObserveMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getObserveMethod = ElectionGrpc.getObserveMethod) == null) {
          ElectionGrpc.getObserveMethod = getObserveMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.LeaderRequest, io.etcd.jetcd.api.LeaderResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Observe"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.LeaderRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.LeaderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Observe"))
              .build();
        }
      }
    }
    return getObserveMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.ResignRequest,
      io.etcd.jetcd.api.ResignResponse> getResignMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Resign",
      requestType = io.etcd.jetcd.api.ResignRequest.class,
      responseType = io.etcd.jetcd.api.ResignResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.ResignRequest,
      io.etcd.jetcd.api.ResignResponse> getResignMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.ResignRequest, io.etcd.jetcd.api.ResignResponse> getResignMethod;
    if ((getResignMethod = ElectionGrpc.getResignMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getResignMethod = ElectionGrpc.getResignMethod) == null) {
          ElectionGrpc.getResignMethod = getResignMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.ResignRequest, io.etcd.jetcd.api.ResignResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Resign"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.ResignRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.ResignResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Resign"))
              .build();
        }
      }
    }
    return getResignMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ElectionStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ElectionStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ElectionStub>() {
        @java.lang.Override
        public ElectionStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ElectionStub(channel, callOptions);
        }
      };
    return ElectionStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ElectionBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ElectionBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ElectionBlockingStub>() {
        @java.lang.Override
        public ElectionBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ElectionBlockingStub(channel, callOptions);
        }
      };
    return ElectionBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ElectionFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<ElectionFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<ElectionFutureStub>() {
        @java.lang.Override
        public ElectionFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new ElectionFutureStub(channel, callOptions);
        }
      };
    return ElectionFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    default void campaign(io.etcd.jetcd.api.CampaignRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.CampaignResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCampaignMethod(), responseObserver);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    default void proclaim(io.etcd.jetcd.api.ProclaimRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ProclaimResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getProclaimMethod(), responseObserver);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    default void leader(io.etcd.jetcd.api.LeaderRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getLeaderMethod(), responseObserver);
    }

    /**
     * <pre>
     * Observe streams election proclamations in-order as made by the election's
     * elected leaders.
     * </pre>
     */
    default void observe(io.etcd.jetcd.api.LeaderRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getObserveMethod(), responseObserver);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    default void resign(io.etcd.jetcd.api.ResignRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ResignResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getResignMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Election.
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static abstract class ElectionImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return ElectionGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Election.
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static final class ElectionStub
      extends io.grpc.stub.AbstractAsyncStub<ElectionStub> {
    private ElectionStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ElectionStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ElectionStub(channel, callOptions);
    }

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public void campaign(io.etcd.jetcd.api.CampaignRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.CampaignResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCampaignMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public void proclaim(io.etcd.jetcd.api.ProclaimRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ProclaimResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getProclaimMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public void leader(io.etcd.jetcd.api.LeaderRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getLeaderMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Observe streams election proclamations in-order as made by the election's
     * elected leaders.
     * </pre>
     */
    public void observe(io.etcd.jetcd.api.LeaderRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getObserveMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public void resign(io.etcd.jetcd.api.ResignRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ResignResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getResignMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Election.
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static final class ElectionBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<ElectionBlockingStub> {
    private ElectionBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ElectionBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ElectionBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public io.etcd.jetcd.api.CampaignResponse campaign(io.etcd.jetcd.api.CampaignRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCampaignMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public io.etcd.jetcd.api.ProclaimResponse proclaim(io.etcd.jetcd.api.ProclaimRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getProclaimMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public io.etcd.jetcd.api.LeaderResponse leader(io.etcd.jetcd.api.LeaderRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getLeaderMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Observe streams election proclamations in-order as made by the election's
     * elected leaders.
     * </pre>
     */
    public java.util.Iterator<io.etcd.jetcd.api.LeaderResponse> observe(
        io.etcd.jetcd.api.LeaderRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getObserveMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public io.etcd.jetcd.api.ResignResponse resign(io.etcd.jetcd.api.ResignRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getResignMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Election.
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static final class ElectionFutureStub
      extends io.grpc.stub.AbstractFutureStub<ElectionFutureStub> {
    private ElectionFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ElectionFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new ElectionFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.etcd.jetcd.api.CampaignResponse> campaign(
        io.etcd.jetcd.api.CampaignRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCampaignMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.etcd.jetcd.api.ProclaimResponse> proclaim(
        io.etcd.jetcd.api.ProclaimRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getProclaimMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.etcd.jetcd.api.LeaderResponse> leader(
        io.etcd.jetcd.api.LeaderRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getLeaderMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.etcd.jetcd.api.ResignResponse> resign(
        io.etcd.jetcd.api.ResignRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getResignMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CAMPAIGN = 0;
  private static final int METHODID_PROCLAIM = 1;
  private static final int METHODID_LEADER = 2;
  private static final int METHODID_OBSERVE = 3;
  private static final int METHODID_RESIGN = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CAMPAIGN:
          serviceImpl.campaign((io.etcd.jetcd.api.CampaignRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.CampaignResponse>) responseObserver);
          break;
        case METHODID_PROCLAIM:
          serviceImpl.proclaim((io.etcd.jetcd.api.ProclaimRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ProclaimResponse>) responseObserver);
          break;
        case METHODID_LEADER:
          serviceImpl.leader((io.etcd.jetcd.api.LeaderRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse>) responseObserver);
          break;
        case METHODID_OBSERVE:
          serviceImpl.observe((io.etcd.jetcd.api.LeaderRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse>) responseObserver);
          break;
        case METHODID_RESIGN:
          serviceImpl.resign((io.etcd.jetcd.api.ResignRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ResignResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getCampaignMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.etcd.jetcd.api.CampaignRequest,
              io.etcd.jetcd.api.CampaignResponse>(
                service, METHODID_CAMPAIGN)))
        .addMethod(
          getProclaimMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.etcd.jetcd.api.ProclaimRequest,
              io.etcd.jetcd.api.ProclaimResponse>(
                service, METHODID_PROCLAIM)))
        .addMethod(
          getLeaderMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.etcd.jetcd.api.LeaderRequest,
              io.etcd.jetcd.api.LeaderResponse>(
                service, METHODID_LEADER)))
        .addMethod(
          getObserveMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              io.etcd.jetcd.api.LeaderRequest,
              io.etcd.jetcd.api.LeaderResponse>(
                service, METHODID_OBSERVE)))
        .addMethod(
          getResignMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.etcd.jetcd.api.ResignRequest,
              io.etcd.jetcd.api.ResignResponse>(
                service, METHODID_RESIGN)))
        .build();
  }

  private static abstract class ElectionBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ElectionBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.etcd.jetcd.api.ElectionOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Election");
    }
  }

  private static final class ElectionFileDescriptorSupplier
      extends ElectionBaseDescriptorSupplier {
    ElectionFileDescriptorSupplier() {}
  }

  private static final class ElectionMethodDescriptorSupplier
      extends ElectionBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    ElectionMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ElectionGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ElectionFileDescriptorSupplier())
              .addMethod(getCampaignMethod())
              .addMethod(getProclaimMethod())
              .addMethod(getLeaderMethod())
              .addMethod(getObserveMethod())
              .addMethod(getResignMethod())
              .build();
        }
      }
    }
    return result;
  }
}
