package io.etcd.jetcd.api.lock;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The lock service exposes client-side locking facilities as a gRPC interface.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.68.1)",
    comments = "Source: lock.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class LockGrpc {

  private LockGrpc() {}

  public static final java.lang.String SERVICE_NAME = "v3lockpb.Lock";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.lock.LockRequest,
      io.etcd.jetcd.api.lock.LockResponse> getLockMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Lock",
      requestType = io.etcd.jetcd.api.lock.LockRequest.class,
      responseType = io.etcd.jetcd.api.lock.LockResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.lock.LockRequest,
      io.etcd.jetcd.api.lock.LockResponse> getLockMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.lock.LockRequest, io.etcd.jetcd.api.lock.LockResponse> getLockMethod;
    if ((getLockMethod = LockGrpc.getLockMethod) == null) {
      synchronized (LockGrpc.class) {
        if ((getLockMethod = LockGrpc.getLockMethod) == null) {
          LockGrpc.getLockMethod = getLockMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.lock.LockRequest, io.etcd.jetcd.api.lock.LockResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Lock"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.lock.LockRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.lock.LockResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LockMethodDescriptorSupplier("Lock"))
              .build();
        }
      }
    }
    return getLockMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.etcd.jetcd.api.lock.UnlockRequest,
      io.etcd.jetcd.api.lock.UnlockResponse> getUnlockMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Unlock",
      requestType = io.etcd.jetcd.api.lock.UnlockRequest.class,
      responseType = io.etcd.jetcd.api.lock.UnlockResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.etcd.jetcd.api.lock.UnlockRequest,
      io.etcd.jetcd.api.lock.UnlockResponse> getUnlockMethod() {
    io.grpc.MethodDescriptor<io.etcd.jetcd.api.lock.UnlockRequest, io.etcd.jetcd.api.lock.UnlockResponse> getUnlockMethod;
    if ((getUnlockMethod = LockGrpc.getUnlockMethod) == null) {
      synchronized (LockGrpc.class) {
        if ((getUnlockMethod = LockGrpc.getUnlockMethod) == null) {
          LockGrpc.getUnlockMethod = getUnlockMethod =
              io.grpc.MethodDescriptor.<io.etcd.jetcd.api.lock.UnlockRequest, io.etcd.jetcd.api.lock.UnlockResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Unlock"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.lock.UnlockRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.etcd.jetcd.api.lock.UnlockResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LockMethodDescriptorSupplier("Unlock"))
              .build();
        }
      }
    }
    return getUnlockMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static LockStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<LockStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<LockStub>() {
        @java.lang.Override
        public LockStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new LockStub(channel, callOptions);
        }
      };
    return LockStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static LockBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<LockBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<LockBlockingStub>() {
        @java.lang.Override
        public LockBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new LockBlockingStub(channel, callOptions);
        }
      };
    return LockBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static LockFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<LockFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<LockFutureStub>() {
        @java.lang.Override
        public LockFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new LockFutureStub(channel, callOptions);
        }
      };
    return LockFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    default void lock(io.etcd.jetcd.api.lock.LockRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.LockResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getLockMethod(), responseObserver);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    default void unlock(io.etcd.jetcd.api.lock.UnlockRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.UnlockResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUnlockMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Lock.
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static abstract class LockImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return LockGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Lock.
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static final class LockStub
      extends io.grpc.stub.AbstractAsyncStub<LockStub> {
    private LockStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LockStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new LockStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public void lock(io.etcd.jetcd.api.lock.LockRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.LockResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getLockMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public void unlock(io.etcd.jetcd.api.lock.UnlockRequest request,
        io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.UnlockResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUnlockMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Lock.
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static final class LockBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<LockBlockingStub> {
    private LockBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LockBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new LockBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public io.etcd.jetcd.api.lock.LockResponse lock(io.etcd.jetcd.api.lock.LockRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getLockMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public io.etcd.jetcd.api.lock.UnlockResponse unlock(io.etcd.jetcd.api.lock.UnlockRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUnlockMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Lock.
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static final class LockFutureStub
      extends io.grpc.stub.AbstractFutureStub<LockFutureStub> {
    private LockFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LockFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new LockFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.etcd.jetcd.api.lock.LockResponse> lock(
        io.etcd.jetcd.api.lock.LockRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getLockMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.etcd.jetcd.api.lock.UnlockResponse> unlock(
        io.etcd.jetcd.api.lock.UnlockRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUnlockMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LOCK = 0;
  private static final int METHODID_UNLOCK = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LOCK:
          serviceImpl.lock((io.etcd.jetcd.api.lock.LockRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.LockResponse>) responseObserver);
          break;
        case METHODID_UNLOCK:
          serviceImpl.unlock((io.etcd.jetcd.api.lock.UnlockRequest) request,
              (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.UnlockResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getLockMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.etcd.jetcd.api.lock.LockRequest,
              io.etcd.jetcd.api.lock.LockResponse>(
                service, METHODID_LOCK)))
        .addMethod(
          getUnlockMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.etcd.jetcd.api.lock.UnlockRequest,
              io.etcd.jetcd.api.lock.UnlockResponse>(
                service, METHODID_UNLOCK)))
        .build();
  }

  private static abstract class LockBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    LockBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.etcd.jetcd.api.lock.JetcdProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Lock");
    }
  }

  private static final class LockFileDescriptorSupplier
      extends LockBaseDescriptorSupplier {
    LockFileDescriptorSupplier() {}
  }

  private static final class LockMethodDescriptorSupplier
      extends LockBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    LockMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (LockGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new LockFileDescriptorSupplier())
              .addMethod(getLockMethod())
              .addMethod(getUnlockMethod())
              .build();
        }
      }
    }
    return result;
  }
}
