package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.AuthGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: rpc.proto")
public final class VertxAuthGrpc {
    private VertxAuthGrpc() {}

    public static AuthVertxStub newVertxStub(io.grpc.Channel channel) {
        return new AuthVertxStub(channel);
    }

    
    public static final class AuthVertxStub extends io.grpc.stub.AbstractStub<AuthVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private AuthGrpc.AuthStub delegateStub;

        private AuthVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = AuthGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private AuthVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = AuthGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected AuthVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new AuthVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthEnableResponse> authEnable(io.etcd.jetcd.api.AuthEnableRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::authEnable);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthDisableResponse> authDisable(io.etcd.jetcd.api.AuthDisableRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::authDisable);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthenticateResponse> authenticate(io.etcd.jetcd.api.AuthenticateRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::authenticate);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserAddResponse> userAdd(io.etcd.jetcd.api.AuthUserAddRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userAdd);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserGetResponse> userGet(io.etcd.jetcd.api.AuthUserGetRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userGet);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserListResponse> userList(io.etcd.jetcd.api.AuthUserListRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userList);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserDeleteResponse> userDelete(io.etcd.jetcd.api.AuthUserDeleteRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userDelete);
        }

        /**
         * <pre>
         *  UserChangePassword changes the password of a specified user.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserChangePasswordResponse> userChangePassword(io.etcd.jetcd.api.AuthUserChangePasswordRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userChangePassword);
        }

        /**
         * <pre>
         *  UserGrant grants a role to a specified user.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserGrantRoleResponse> userGrantRole(io.etcd.jetcd.api.AuthUserGrantRoleRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userGrantRole);
        }

        /**
         * <pre>
         *  UserRevokeRole revokes a role of specified user.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserRevokeRoleResponse> userRevokeRole(io.etcd.jetcd.api.AuthUserRevokeRoleRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::userRevokeRole);
        }

        /**
         * <pre>
         *  RoleAdd adds a new role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleAddResponse> roleAdd(io.etcd.jetcd.api.AuthRoleAddRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleAdd);
        }

        /**
         * <pre>
         *  RoleGet gets detailed role information.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleGetResponse> roleGet(io.etcd.jetcd.api.AuthRoleGetRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleGet);
        }

        /**
         * <pre>
         *  RoleList gets lists of all roles.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleListResponse> roleList(io.etcd.jetcd.api.AuthRoleListRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleList);
        }

        /**
         * <pre>
         *  RoleDelete deletes a specified role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleDeleteResponse> roleDelete(io.etcd.jetcd.api.AuthRoleDeleteRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleDelete);
        }

        /**
         * <pre>
         *  RoleGrantPermission grants a permission of a specified key or range to a specified role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleGrantPermissionResponse> roleGrantPermission(io.etcd.jetcd.api.AuthRoleGrantPermissionRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleGrantPermission);
        }

        /**
         * <pre>
         *  RoleRevokePermission revokes a key or range permission of a specified role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleRevokePermissionResponse> roleRevokePermission(io.etcd.jetcd.api.AuthRoleRevokePermissionRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::roleRevokePermission);
        }

    }

    
    public static abstract class AuthVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public AuthVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthEnableResponse> authEnable(io.etcd.jetcd.api.AuthEnableRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthDisableResponse> authDisable(io.etcd.jetcd.api.AuthDisableRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthenticateResponse> authenticate(io.etcd.jetcd.api.AuthenticateRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserAddResponse> userAdd(io.etcd.jetcd.api.AuthUserAddRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserGetResponse> userGet(io.etcd.jetcd.api.AuthUserGetRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserListResponse> userList(io.etcd.jetcd.api.AuthUserListRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserDeleteResponse> userDelete(io.etcd.jetcd.api.AuthUserDeleteRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  UserChangePassword changes the password of a specified user.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserChangePasswordResponse> userChangePassword(io.etcd.jetcd.api.AuthUserChangePasswordRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  UserGrant grants a role to a specified user.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserGrantRoleResponse> userGrantRole(io.etcd.jetcd.api.AuthUserGrantRoleRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  UserRevokeRole revokes a role of specified user.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthUserRevokeRoleResponse> userRevokeRole(io.etcd.jetcd.api.AuthUserRevokeRoleRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleAdd adds a new role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleAddResponse> roleAdd(io.etcd.jetcd.api.AuthRoleAddRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleGet gets detailed role information.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleGetResponse> roleGet(io.etcd.jetcd.api.AuthRoleGetRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleList gets lists of all roles.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleListResponse> roleList(io.etcd.jetcd.api.AuthRoleListRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleDelete deletes a specified role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleDeleteResponse> roleDelete(io.etcd.jetcd.api.AuthRoleDeleteRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleGrantPermission grants a permission of a specified key or range to a specified role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleGrantPermissionResponse> roleGrantPermission(io.etcd.jetcd.api.AuthRoleGrantPermissionRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  RoleRevokePermission revokes a key or range permission of a specified role.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.AuthRoleRevokePermissionResponse> roleRevokePermission(io.etcd.jetcd.api.AuthRoleRevokePermissionRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getAuthEnableMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthEnableRequest,
                                            io.etcd.jetcd.api.AuthEnableResponse>(
                                            this, METHODID_AUTH_ENABLE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getAuthDisableMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthDisableRequest,
                                            io.etcd.jetcd.api.AuthDisableResponse>(
                                            this, METHODID_AUTH_DISABLE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getAuthenticateMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthenticateRequest,
                                            io.etcd.jetcd.api.AuthenticateResponse>(
                                            this, METHODID_AUTHENTICATE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserAddMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserAddRequest,
                                            io.etcd.jetcd.api.AuthUserAddResponse>(
                                            this, METHODID_USER_ADD, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserGetMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserGetRequest,
                                            io.etcd.jetcd.api.AuthUserGetResponse>(
                                            this, METHODID_USER_GET, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserListMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserListRequest,
                                            io.etcd.jetcd.api.AuthUserListResponse>(
                                            this, METHODID_USER_LIST, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserDeleteMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserDeleteRequest,
                                            io.etcd.jetcd.api.AuthUserDeleteResponse>(
                                            this, METHODID_USER_DELETE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserChangePasswordMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserChangePasswordRequest,
                                            io.etcd.jetcd.api.AuthUserChangePasswordResponse>(
                                            this, METHODID_USER_CHANGE_PASSWORD, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserGrantRoleMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserGrantRoleRequest,
                                            io.etcd.jetcd.api.AuthUserGrantRoleResponse>(
                                            this, METHODID_USER_GRANT_ROLE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getUserRevokeRoleMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthUserRevokeRoleRequest,
                                            io.etcd.jetcd.api.AuthUserRevokeRoleResponse>(
                                            this, METHODID_USER_REVOKE_ROLE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getRoleAddMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthRoleAddRequest,
                                            io.etcd.jetcd.api.AuthRoleAddResponse>(
                                            this, METHODID_ROLE_ADD, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getRoleGetMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthRoleGetRequest,
                                            io.etcd.jetcd.api.AuthRoleGetResponse>(
                                            this, METHODID_ROLE_GET, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getRoleListMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthRoleListRequest,
                                            io.etcd.jetcd.api.AuthRoleListResponse>(
                                            this, METHODID_ROLE_LIST, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getRoleDeleteMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthRoleDeleteRequest,
                                            io.etcd.jetcd.api.AuthRoleDeleteResponse>(
                                            this, METHODID_ROLE_DELETE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getRoleGrantPermissionMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthRoleGrantPermissionRequest,
                                            io.etcd.jetcd.api.AuthRoleGrantPermissionResponse>(
                                            this, METHODID_ROLE_GRANT_PERMISSION, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.AuthGrpc.getRoleRevokePermissionMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.AuthRoleRevokePermissionRequest,
                                            io.etcd.jetcd.api.AuthRoleRevokePermissionResponse>(
                                            this, METHODID_ROLE_REVOKE_PERMISSION, compression)))
                    .build();
        }
    }

    private static final int METHODID_AUTH_ENABLE = 0;
    private static final int METHODID_AUTH_DISABLE = 1;
    private static final int METHODID_AUTHENTICATE = 2;
    private static final int METHODID_USER_ADD = 3;
    private static final int METHODID_USER_GET = 4;
    private static final int METHODID_USER_LIST = 5;
    private static final int METHODID_USER_DELETE = 6;
    private static final int METHODID_USER_CHANGE_PASSWORD = 7;
    private static final int METHODID_USER_GRANT_ROLE = 8;
    private static final int METHODID_USER_REVOKE_ROLE = 9;
    private static final int METHODID_ROLE_ADD = 10;
    private static final int METHODID_ROLE_GET = 11;
    private static final int METHODID_ROLE_LIST = 12;
    private static final int METHODID_ROLE_DELETE = 13;
    private static final int METHODID_ROLE_GRANT_PERMISSION = 14;
    private static final int METHODID_ROLE_REVOKE_PERMISSION = 15;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final AuthVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(AuthVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_AUTH_ENABLE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthEnableRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthEnableResponse>) responseObserver,
                            compression,
                            serviceImpl::authEnable);
                    break;
                case METHODID_AUTH_DISABLE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthDisableRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthDisableResponse>) responseObserver,
                            compression,
                            serviceImpl::authDisable);
                    break;
                case METHODID_AUTHENTICATE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthenticateRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthenticateResponse>) responseObserver,
                            compression,
                            serviceImpl::authenticate);
                    break;
                case METHODID_USER_ADD:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserAddRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserAddResponse>) responseObserver,
                            compression,
                            serviceImpl::userAdd);
                    break;
                case METHODID_USER_GET:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserGetRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserGetResponse>) responseObserver,
                            compression,
                            serviceImpl::userGet);
                    break;
                case METHODID_USER_LIST:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserListRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserListResponse>) responseObserver,
                            compression,
                            serviceImpl::userList);
                    break;
                case METHODID_USER_DELETE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserDeleteRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserDeleteResponse>) responseObserver,
                            compression,
                            serviceImpl::userDelete);
                    break;
                case METHODID_USER_CHANGE_PASSWORD:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserChangePasswordRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserChangePasswordResponse>) responseObserver,
                            compression,
                            serviceImpl::userChangePassword);
                    break;
                case METHODID_USER_GRANT_ROLE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserGrantRoleRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserGrantRoleResponse>) responseObserver,
                            compression,
                            serviceImpl::userGrantRole);
                    break;
                case METHODID_USER_REVOKE_ROLE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthUserRevokeRoleRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthUserRevokeRoleResponse>) responseObserver,
                            compression,
                            serviceImpl::userRevokeRole);
                    break;
                case METHODID_ROLE_ADD:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthRoleAddRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthRoleAddResponse>) responseObserver,
                            compression,
                            serviceImpl::roleAdd);
                    break;
                case METHODID_ROLE_GET:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthRoleGetRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthRoleGetResponse>) responseObserver,
                            compression,
                            serviceImpl::roleGet);
                    break;
                case METHODID_ROLE_LIST:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthRoleListRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthRoleListResponse>) responseObserver,
                            compression,
                            serviceImpl::roleList);
                    break;
                case METHODID_ROLE_DELETE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthRoleDeleteRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthRoleDeleteResponse>) responseObserver,
                            compression,
                            serviceImpl::roleDelete);
                    break;
                case METHODID_ROLE_GRANT_PERMISSION:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthRoleGrantPermissionRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthRoleGrantPermissionResponse>) responseObserver,
                            compression,
                            serviceImpl::roleGrantPermission);
                    break;
                case METHODID_ROLE_REVOKE_PERMISSION:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.AuthRoleRevokePermissionRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.AuthRoleRevokePermissionResponse>) responseObserver,
                            compression,
                            serviceImpl::roleRevokePermission);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
