package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.ClusterGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: rpc.proto")
public final class VertxClusterGrpc {
    private VertxClusterGrpc() {}

    public static ClusterVertxStub newVertxStub(io.grpc.Channel channel) {
        return new ClusterVertxStub(channel);
    }

    
    public static final class ClusterVertxStub extends io.grpc.stub.AbstractStub<ClusterVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private ClusterGrpc.ClusterStub delegateStub;

        private ClusterVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = ClusterGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private ClusterVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = ClusterGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected ClusterVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new ClusterVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberAddResponse> memberAdd(io.etcd.jetcd.api.MemberAddRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberAdd);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberRemoveResponse> memberRemove(io.etcd.jetcd.api.MemberRemoveRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberRemove);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberUpdateResponse> memberUpdate(io.etcd.jetcd.api.MemberUpdateRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberUpdate);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberListResponse> memberList(io.etcd.jetcd.api.MemberListRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberList);
        }

    }

    
    public static abstract class ClusterVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public ClusterVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberAddResponse> memberAdd(io.etcd.jetcd.api.MemberAddRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberRemoveResponse> memberRemove(io.etcd.jetcd.api.MemberRemoveRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberUpdateResponse> memberUpdate(io.etcd.jetcd.api.MemberUpdateRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.MemberListResponse> memberList(io.etcd.jetcd.api.MemberListRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.ClusterGrpc.getMemberAddMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.MemberAddRequest,
                                            io.etcd.jetcd.api.MemberAddResponse>(
                                            this, METHODID_MEMBER_ADD, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ClusterGrpc.getMemberRemoveMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.MemberRemoveRequest,
                                            io.etcd.jetcd.api.MemberRemoveResponse>(
                                            this, METHODID_MEMBER_REMOVE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ClusterGrpc.getMemberUpdateMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.MemberUpdateRequest,
                                            io.etcd.jetcd.api.MemberUpdateResponse>(
                                            this, METHODID_MEMBER_UPDATE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ClusterGrpc.getMemberListMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.MemberListRequest,
                                            io.etcd.jetcd.api.MemberListResponse>(
                                            this, METHODID_MEMBER_LIST, compression)))
                    .build();
        }
    }

    private static final int METHODID_MEMBER_ADD = 0;
    private static final int METHODID_MEMBER_REMOVE = 1;
    private static final int METHODID_MEMBER_UPDATE = 2;
    private static final int METHODID_MEMBER_LIST = 3;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final ClusterVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ClusterVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_MEMBER_ADD:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.MemberAddRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.MemberAddResponse>) responseObserver,
                            compression,
                            serviceImpl::memberAdd);
                    break;
                case METHODID_MEMBER_REMOVE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.MemberRemoveRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.MemberRemoveResponse>) responseObserver,
                            compression,
                            serviceImpl::memberRemove);
                    break;
                case METHODID_MEMBER_UPDATE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.MemberUpdateRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.MemberUpdateResponse>) responseObserver,
                            compression,
                            serviceImpl::memberUpdate);
                    break;
                case METHODID_MEMBER_LIST:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.MemberListRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.MemberListResponse>) responseObserver,
                            compression,
                            serviceImpl::memberList);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
