/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.launcher.junit4;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.etcd.jetcd.launcher.EtcdCluster;
import io.etcd.jetcd.launcher.EtcdClusterFactory;
import java.net.URI;
import java.util.List;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClusterResource
extends ExternalResource
implements EtcdCluster {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdClusterResource.class);
    private final EtcdCluster cluster;

    public EtcdClusterResource(String clusterName) {
        this(clusterName, 1, false);
    }

    public EtcdClusterResource(String clusterName, int nodes) {
        this(clusterName, nodes, false);
    }

    public EtcdClusterResource(String clusterName, int nodes, boolean ssl) {
        this(clusterName, nodes, ssl, false);
    }

    public EtcdClusterResource(String clusterName, int nodes, boolean ssl, boolean restartable) {
        this.cluster = EtcdClusterFactory.buildCluster(clusterName, nodes, ssl, restartable, new String[0]);
    }

    protected void before() throws Throwable {
        this.cluster.start();
    }

    protected void after() {
        try {
            this.cluster.close();
        }
        catch (RuntimeException e) {
            LOG.warn("close() failed (but ignoring it)", (Throwable)e);
        }
    }

    @Override
    public void start() {
        this.cluster.start();
    }

    @Override
    public void restart() {
        this.cluster.restart();
    }

    @Override
    public void close() {
        this.cluster.close();
    }

    @Override
    @NonNull
    public List<URI> getClientEndpoints() {
        return this.cluster.getClientEndpoints();
    }

    @Override
    @NonNull
    public List<URI> getPeerEndpoints() {
        return this.cluster.getPeerEndpoints();
    }
}

