/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.launcher;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class EtcdContainer
extends GenericContainer<EtcdContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdContainer.class);
    private final AtomicBoolean configured = new AtomicBoolean();
    private final String node;
    private final Set<String> nodes;
    private String clusterToken;
    private boolean ssl;
    private Path dataDirectory;
    private Collection<String> additionalArgs;

    public EtcdContainer(String image, String node, Collection<String> nodes) {
        super(image);
        this.node = node;
        this.nodes = new HashSet<String>(nodes);
        this.nodes.add(node);
    }

    public EtcdContainer withSll(boolean ssl) {
        this.ssl = ssl;
        return (EtcdContainer)this.self();
    }

    public EtcdContainer withClusterToken(String clusterToken) {
        this.clusterToken = clusterToken;
        return (EtcdContainer)this.self();
    }

    public EtcdContainer withAdditionalArgs(Collection<String> additionalArgs) {
        if (additionalArgs != null) {
            this.additionalArgs = List.copyOf(additionalArgs);
        }
        return (EtcdContainer)this.self();
    }

    protected void configure() {
        if (!this.configured.compareAndSet(false, true)) {
            return;
        }
        this.dataDirectory = this.createDataDirectory(this.node);
        this.addFileSystemBind(this.dataDirectory.toString(), "/data.etcd", BindMode.READ_WRITE, SelinuxContext.SHARED);
        this.withExposedPorts(new Integer[]{2380, 2379});
        this.withNetworkAliases(new String[]{this.node});
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER).withPrefix(this.node));
        this.withCommand(this.createCommand());
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*ready to serve client requests.*", (int)1));
    }

    private Path createDataDirectory(String name) {
        try {
            String prefix = "jetcd_test_" + name + "_";
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                FileAttribute<Set<PosixFilePermission>> attribute = PosixFilePermissions.asFileAttribute(EnumSet.allOf(PosixFilePermission.class));
                return Files.createTempDirectory(prefix, attribute).toRealPath(new LinkOption[0]);
            }
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ContainerLaunchException("Error creating data directory", (Throwable)e);
        }
    }

    private String[] createCommand() {
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add("etcd");
        cmd.add("--name");
        cmd.add(this.node);
        cmd.add("--advertise-client-urls");
        cmd.add((this.ssl ? "https" : "http") + "://0.0.0.0:2379");
        cmd.add("--listen-client-urls");
        cmd.add((this.ssl ? "https" : "http") + "://0.0.0.0:2379");
        cmd.add("--data-dir");
        cmd.add("/data.etcd");
        if (this.ssl) {
            this.withClasspathResourceMapping("ssl/cert/" + this.node + ".pem", "/etc/ssl/etcd/server.pem", BindMode.READ_ONLY, SelinuxContext.SHARED);
            this.withClasspathResourceMapping("ssl/cert/" + this.node + "-key.pem", "/etc/ssl/etcd/server-key.pem", BindMode.READ_ONLY, SelinuxContext.SHARED);
            cmd.add("--cert-file");
            cmd.add("/etc/ssl/etcd/server.pem");
            cmd.add("--key-file");
            cmd.add("/etc/ssl/etcd/server-key.pem");
        }
        if (this.nodes.size() > 1) {
            cmd.add("--initial-advertise-peer-urls");
            cmd.add("http://" + this.node + ":2380");
            cmd.add("--listen-peer-urls");
            cmd.add("http://0.0.0.0:2380");
            cmd.add("--initial-cluster");
            cmd.add(this.nodes.stream().map(e -> e + "=http://" + e + ":2380").collect(Collectors.joining(",")));
            cmd.add("--initial-cluster-state");
            cmd.add("new");
            if (this.clusterToken != null) {
                cmd.add("--initial-cluster-token");
                cmd.add(this.clusterToken);
            }
        }
        if (this.additionalArgs != null) {
            cmd.addAll(this.additionalArgs);
        }
        return cmd.toArray(new String[0]);
    }

    private static void deleteDataDirectory(Path dir) {
        if (dir != null && Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                LOGGER.error("Error deleting directory {}", (Object)dir, (Object)e);
            }
        }
    }

    public void start() {
        LOGGER.debug("starting etcd container {} with command: {}", (Object)this.node, (Object)String.join((CharSequence)" ", this.getCommandParts()));
        try {
            super.start();
            this.execInContainer(new String[]{"chmod", "o+rwx", "-R", "/data.etcd"});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        super.close();
        EtcdContainer.deleteDataDirectory(this.dataDirectory);
    }

    public String node() {
        return this.node;
    }

    public InetSocketAddress getClientAddress() {
        return new InetSocketAddress(this.getContainerIpAddress(), (int)this.getMappedPort(2379));
    }

    public URI clientEndpoint() {
        return this.newURI(this.getContainerIpAddress(), this.getMappedPort(2379));
    }

    public InetSocketAddress getPeerAddress() {
        return new InetSocketAddress(this.getContainerIpAddress(), (int)this.getMappedPort(2380));
    }

    public URI peerEndpoint() {
        return this.newURI(this.getContainerIpAddress(), this.getMappedPort(2380));
    }

    private URI newURI(String host, int port) {
        try {
            return new URI(this.ssl ? "https" : "http", null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URISyntaxException should never happen here", e);
        }
    }
}

