/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.launcher;

import io.etcd.jetcd.launcher.EtcdCluster;
import io.etcd.jetcd.launcher.EtcdContainer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testcontainers.containers.Network;

public class EtcdClusterImpl
implements EtcdCluster {
    private final List<EtcdContainer> containers;
    private final String clusterName;
    private final List<String> endpoints;

    public EtcdClusterImpl(String image, String clusterName, String prefix, int nodes, boolean ssl, boolean debug, Collection<String> additionalArgs, Network network, boolean shouldMountDataDirectory, String user) {
        this.clusterName = clusterName;
        this.endpoints = IntStream.range(0, nodes).mapToObj(i -> (String)(prefix == null ? "etcd" : prefix + "etcd") + i).collect(Collectors.toList());
        this.containers = this.endpoints.stream().map(e -> ((EtcdContainer)new EtcdContainer(image, (String)e, (Collection<String>)this.endpoints).withClusterToken(clusterName).withSll(ssl).withDebug(debug).withAdditionalArgs(additionalArgs).withNetwork(network)).withShouldMountDataDirectory(shouldMountDataDirectory).withUser(user)).collect(Collectors.toList());
    }

    public void start() {
        CountDownLatch latch = new CountDownLatch(this.containers.size());
        AtomicReference failedToStart = new AtomicReference();
        for (EtcdContainer container : this.containers) {
            new Thread(() -> {
                try {
                    container.start();
                }
                catch (Exception e) {
                    failedToStart.set(e);
                }
                finally {
                    latch.countDown();
                }
            }).start();
        }
        try {
            latch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (failedToStart.get() != null) {
            throw new IllegalStateException("Cluster failed to start", (Throwable)failedToStart.get());
        }
    }

    public void stop() {
        for (EtcdContainer container : this.containers) {
            container.stop();
        }
    }

    public void close() {
        for (EtcdContainer container : this.containers) {
            container.close();
        }
    }

    @Override
    public String clusterName() {
        return this.clusterName;
    }

    @Override
    public List<URI> clientEndpoints() {
        return this.containers.stream().map(EtcdContainer::clientEndpoint).collect(Collectors.toList());
    }

    @Override
    public List<URI> peerEndpoints() {
        return this.containers.stream().map(EtcdContainer::peerEndpoint).collect(Collectors.toList());
    }

    @Override
    public List<EtcdContainer> containers() {
        return Collections.unmodifiableList(this.containers);
    }
}

