/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.osgi;

import io.etcd.jetcd.Auth;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.Cluster;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Maintenance;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.resolver.URIResolver;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Client.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"io.etcd.jetcd"})
@Designate(ocd=Configuration.class)
public class ClientService
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientService.class);
    private final Set<URIResolver> resolvers = new HashSet<URIResolver>();
    private Client delegate;

    public Auth getAuthClient() {
        return this.delegate.getAuthClient();
    }

    public KV getKVClient() {
        return this.delegate.getKVClient();
    }

    public Cluster getClusterClient() {
        return this.delegate.getClusterClient();
    }

    public Maintenance getMaintenanceClient() {
        return this.delegate.getMaintenanceClient();
    }

    public Lease getLeaseClient() {
        return this.delegate.getLeaseClient();
    }

    public Watch getWatchClient() {
        return this.delegate.getWatchClient();
    }

    public Lock getLockClient() {
        return this.delegate.getLockClient();
    }

    public Election getElectionClient() {
        return this.delegate.getElectionClient();
    }

    public void close() {
        throw new UnsupportedOperationException("");
    }

    @Activate
    protected void activate(Configuration config) {
        ClientBuilder builder = Client.builder();
        builder.endpoints(config.endpoints());
        builder.uriResolverLoader(() -> this.resolvers);
        if (config.user() != null) {
            builder.user(ByteSequence.from((String)config.user(), (Charset)Charset.forName(config.charset())));
        }
        if (config.password() != null) {
            builder.password(ByteSequence.from((String)config.password(), (Charset)Charset.forName(config.charset())));
        }
        this.delegate = builder.build();
    }

    @Deactivate
    protected void deactivate() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResolver(URIResolver resolver) {
        LOGGER.debug("Adding resolver: {}", (Object)resolver);
        this.resolvers.add(resolver);
    }

    protected void unbindResolver(URIResolver resolver) {
        LOGGER.debug("Remove resolver: {}", (Object)resolver);
        this.resolvers.remove(resolver);
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition
        public String[] endpoints();

        @AttributeDefinition(required=false)
        public String user();

        @AttributeDefinition(required=false, type=AttributeType.PASSWORD)
        public String password();

        @AttributeDefinition(required=false, type=AttributeType.STRING, defaultValue={"UTF-8"}, description="Character Set used for user and password")
        public String charset();
    }
}

