/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb;

import eventcenter.api.CommonEventSource;
import eventcenter.api.utils.SerializeUtils;
import eventcenter.leveldb.EventSourceWrapper;
import eventcenter.leveldb.LevelDBCursor;
import eventcenter.leveldb.LevelDBPage;
import eventcenter.leveldb.LevelDBPersistenceAdapter;
import eventcenter.leveldb.PersistenceException;
import eventcenter.leveldb.utils.LevelDbUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.WriteBatch;

public class QueueMiddleComponent {
    static final String KEY_READ_CURSOR = "rc";
    static final String KEY_WRITE_CURSOR = "wc";
    static final String KEY_DELETE_CURSOR = "dc";
    static final String KEY_PAGE = "p";
    static final String KEY_REAR_PAGE_NO = "rpn";
    static final String KEY_HEAD_PAGE_NO = "hpn";
    static final String SEPERATOR = "_";
    static final int DEFAULT_PAGE_SIZE = 100;
    static final Map<Integer, QueuesStat> queuesStatMap = Collections.synchronizedMap(new HashMap());
    protected volatile LevelDBCursor readCursor;
    protected volatile LevelDBCursor writeCursor;
    protected volatile LevelDBCursor deleteCursor;
    protected volatile LevelDBPage currentPage;
    protected volatile Long rearPageNo;
    protected volatile Long headPageNo;
    protected final ReentrantLock readLock = new ReentrantLock();
    protected ReentrantLock writeLock = new ReentrantLock();
    protected ReentrantLock deleteLock = new ReentrantLock();
    private int pageSize = 100;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final LevelDBPersistenceAdapter adapter;
    protected final String queueName;
    private volatile boolean open = false;
    private boolean openTxn = false;
    public static final long THRESHOLD_SST_FILE_SIZE_OF_COMPACT = 0x6400000L;

    public QueueMiddleComponent(LevelDBPersistenceAdapter adapter) {
        this(adapter, "dq");
    }

    public QueueMiddleComponent(LevelDBPersistenceAdapter adapter, String queueName) {
        this.adapter = adapter;
        this.queueName = queueName;
    }

    protected DB getDB() {
        return this.adapter.getDb();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public synchronized void open() throws IOException {
        if (this.open) {
            return;
        }
        Integer queueHashCode = this.adapter.hashCode();
        if (!queuesStatMap.containsKey(queueHashCode)) {
            queuesStatMap.put(queueHashCode, new QueuesStat());
        }
        if (QueueMiddleComponent.queuesStatMap.get((Object)queueHashCode).states.containsKey(this.queueName) && QueueMiddleComponent.queuesStatMap.get((Object)queueHashCode).states.get(this.queueName).booleanValue()) {
            throw new IOException("[" + this.queueName + "] had been exists, please change leveldb queue name.");
        }
        QueueMiddleComponent.queuesStatMap.get((Object)queueHashCode).states.put(this.queueName, true);
        this.adapter.open();
        try {
            this.load();
        }
        catch (PersistenceException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.open = true;
    }

    public synchronized void close() throws IOException {
        if (!this.open) {
            return;
        }
        Integer queueHashCode = this.adapter.hashCode();
        QueueMiddleComponent.queuesStatMap.get((Object)queueHashCode).states.put(this.queueName, false);
        Collection<Boolean> stats = QueueMiddleComponent.queuesStatMap.get((Object)queueHashCode).states.values();
        this.open = false;
        boolean allClosed = true;
        for (Boolean stat : stats) {
            if (!stat.booleanValue()) continue;
            allClosed = false;
            break;
        }
        if (!allClosed) {
            return;
        }
        this.adapter.close();
    }

    public void load() throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        ReentrantLock writeLock = this.writeLock;
        readLock.lock();
        writeLock.lock();
        try {
            this.loadPage();
            this.loadCursor();
        }
        finally {
            readLock.unlock();
            writeLock.unlock();
        }
    }

    String buildKey(String ... keys) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sb.append(SEPERATOR);
            }
            sb.append(keys[i]);
        }
        return sb.toString();
    }

    protected String wrapperKey(String key) {
        return this.queueName + SEPERATOR + key;
    }

    public boolean isOpenTxn() {
        return this.openTxn;
    }

    public void setOpenTxn(boolean openTxn) {
        this.openTxn = openTxn;
    }

    public <T> T get(String key, Class<T> type) throws PersistenceException {
        return this.adapter.get(this.wrapperKey(key), type);
    }

    protected void put(String key, Serializable ser) throws PersistenceException {
        this.adapter.put(this.wrapperKey(key), ser);
    }

    protected void put(WriteBatch wb, String key, Serializable ser) throws PersistenceException {
        this.adapter.put(this.wrapperKey(key), ser, wb);
    }

    protected void put(String key, Serializable ser, WriteBatch update) throws PersistenceException {
        try {
            update.put(this.wrapperKey(key).getBytes(), SerializeUtils.serialize((Serializable)ser));
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    protected void loadPage() throws PersistenceException {
        this.rearPageNo = this.get(KEY_REAR_PAGE_NO, Long.class);
        if (null == this.rearPageNo) {
            this.rearPageNo = 0L;
            this.put(KEY_REAR_PAGE_NO, this.rearPageNo);
        }
        this.headPageNo = this.get(KEY_HEAD_PAGE_NO, Long.class);
        if (null == this.headPageNo) {
            this.headPageNo = 0L;
            this.put(KEY_HEAD_PAGE_NO, this.headPageNo);
        }
        this.currentPage = this.get(this.buildKey(KEY_PAGE, String.valueOf(this.rearPageNo)), LevelDBPage.class);
        if (null == this.currentPage) {
            this.currentPage = new LevelDBPage();
            this.currentPage.setNo(this.rearPageNo);
            this.currentPage.setIndexes(new ArrayList<String>(this.pageSize));
            this.put(this.buildKey(KEY_PAGE, String.valueOf(this.rearPageNo)), this.currentPage);
        }
    }

    protected void loadCursor() throws PersistenceException {
        this.readCursor = this.get(KEY_READ_CURSOR, LevelDBCursor.class);
        if (null == this.readCursor) {
            this.readCursor = new LevelDBCursor();
            this.readCursor.setPageNo(this.headPageNo);
            this.readCursor.setIndex(0L);
            this.put(KEY_READ_CURSOR, this.readCursor);
        }
        this.writeCursor = this.get(KEY_WRITE_CURSOR, LevelDBCursor.class);
        if (null == this.writeCursor) {
            this.writeCursor = new LevelDBCursor();
            this.writeCursor.setPageNo(this.rearPageNo);
            this.writeCursor.setIndex(0L);
            this.put(KEY_WRITE_CURSOR, this.writeCursor);
        }
        this.deleteCursor = this.get(KEY_DELETE_CURSOR, LevelDBCursor.class);
        if (null == this.deleteCursor) {
            this.deleteCursor = new LevelDBCursor();
            this.deleteCursor.setPageNo(this.headPageNo);
            this.deleteCursor.setIndex(0L);
            this.put(KEY_DELETE_CURSOR, this.deleteCursor);
        }
    }

    protected Long calculateTotalCount() {
        if (null == this.writeCursor || this.readCursor == null) {
            return 0L;
        }
        long gapPageNum = this.writeCursor.getPageNo() - this.readCursor.getPageNo();
        long leftPageSize = this.writeCursor.getIndex() - this.readCursor.getIndex();
        return gapPageNum * (long)this.pageSize + leftPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(CommonEventSource evt) throws PersistenceException {
        ReentrantLock writeLock = this.writeLock;
        writeLock.lock();
        WriteBatch wb = this.adapter.getDb().createWriteBatch();
        EventSourceWrapper wrapper = new EventSourceWrapper(this.adapter.nextId(), evt);
        try {
            if (this.adapter.getDb() == null) {
                this.logger.warn((Object)("leveldb had been closed, eventId:" + evt.getEventId() + " can't be saved"));
                String string = null;
                return string;
            }
            if (null == this.writeCursor) {
                this.writeCursor = this.get(KEY_WRITE_CURSOR, LevelDBCursor.class);
                if (null == this.writeCursor) {
                    this.writeCursor = new LevelDBCursor();
                    this.writeCursor.setPageNo(this.rearPageNo);
                    this.writeCursor.setIndex(1L);
                    this.put(KEY_WRITE_CURSOR, this.writeCursor);
                }
            }
            this.put(wrapper.getTxnId(), wrapper, wb);
            if (this.isCursorToTheEndPage(this.writeCursor)) {
                this.newPage(wrapper.getTxnId(), wb);
            } else {
                this.currentPage.getIndexes().add(wrapper.getTxnId());
                this.writeCursor.setIndex(this.currentPage.getIndexes().size());
                this.put(KEY_WRITE_CURSOR, this.writeCursor, wb);
                this.savePage(this.currentPage, wb);
            }
            DB db = this.adapter.getDb();
            db.write(wb);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)new StringBuilder("save event id:").append(evt.getEventId()).append(" success.").append(", cp:").append(this.currentPage.getNo()).append(this.buildCursorLog(", wc:", this.writeCursor)).append(this.buildCursorLog(", rc:", this.readCursor)).append(this.buildCursorLog(", dc:", this.deleteCursor)));
            }
            String string = wrapper.getTxnId();
            return string;
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
            writeLock.unlock();
        }
    }

    private String buildCursorLog(String prefix, LevelDBCursor c) {
        return prefix + c.getPageNo() + "-" + c.getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSourceWrapper pop() throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        readLock.lock();
        if (null == this.adapter.db) {
            return null;
        }
        WriteBatch wb = this.adapter.db.createWriteBatch();
        try {
            EventSourceWrapper eventSourceWrapper = this.pop(wb);
            return eventSourceWrapper;
        }
        finally {
            this.adapter.db.write(wb);
            try {
                wb.close();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSourceWrapper pop(WriteBatch wb) throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        readLock.lock();
        try {
            List<EventSourceWrapper> list = this.pop(1, wb);
            if (list == null || list.size() == 0) {
                EventSourceWrapper eventSourceWrapper = null;
                return eventSourceWrapper;
            }
            EventSourceWrapper eventSourceWrapper = list.get(0);
            return eventSourceWrapper;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventSourceWrapper> pop(int bulkSize) throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        readLock.lock();
        if (null == this.adapter.db) {
            return new ArrayList<EventSourceWrapper>();
        }
        WriteBatch wb = this.adapter.db.createWriteBatch();
        try {
            List<EventSourceWrapper> list = this.pop(bulkSize, wb);
            return list;
        }
        finally {
            this.adapter.db.write(wb);
            try {
                wb.close();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventSourceWrapper> pop(int bulkSize, WriteBatch wb) throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        readLock.lock();
        try {
            long index = this.readCursor.getIndex();
            List<EventSourceWrapper> list = this._peek(bulkSize);
            if (list == null || list.size() == 0) {
                List<EventSourceWrapper> list2 = list;
                return list2;
            }
            long nextIndex = (long)list.size() + index;
            long nextPageNo = this.calculateNextReadPage(list.size(), nextIndex);
            if (nextPageNo != this.readCursor.getPageNo()) {
                this.readCursor.setIndex(nextIndex % (long)this.pageSize);
            } else {
                this.readCursor.setIndex(nextIndex);
            }
            this.readCursor.setPageNo(nextPageNo);
            this.put(wb, KEY_READ_CURSOR, this.readCursor);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)new StringBuilder("pop leveldb :").append(this.logEventSourceBase(list)).append(", success").append(", cp:").append(this.currentPage.getNo()).append(this.buildCursorLog(", wc:", this.writeCursor)).append(this.buildCursorLog(", rc:", this.readCursor)).append(this.buildCursorLog(", dc:", this.deleteCursor)));
            }
            List<EventSourceWrapper> list3 = list;
            return list3;
        }
        finally {
            readLock.unlock();
        }
    }

    String logEventSourceBase(List<EventSourceWrapper> sources) {
        if (null == sources || sources.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (CommonEventSource commonEventSource : sources) {
            if (index > 0) {
                sb.append(",");
            }
            if (null == commonEventSource) {
                sb.append("source is null");
            } else {
                sb.append(commonEventSource.getEventId()).append(" ").append(commonEventSource.getEventName());
            }
            ++index;
        }
        return sb.toString();
    }

    long calculateNextReadPage(int popSize, long nextIndex) throws PersistenceException {
        long increametal = nextIndex / (long)this.pageSize;
        if (this.readCursor.getPageNo() == Long.MAX_VALUE && increametal > 0L) {
            return increametal - 1L;
        }
        return increametal + this.readCursor.getPageNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSourceWrapper peek() throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        readLock.lock();
        try {
            List<EventSourceWrapper> list = this._peek(1);
            if (list == null || list.size() == 0) {
                EventSourceWrapper eventSourceWrapper = null;
                return eventSourceWrapper;
            }
            EventSourceWrapper eventSourceWrapper = list.get(0);
            return eventSourceWrapper;
        }
        finally {
            readLock.unlock();
        }
    }

    protected List<EventSourceWrapper> _peek(int bulkSize) throws PersistenceException {
        if (this.writeCursor.getPageNo() < this.readCursor.getPageNo() || this.writeCursor.getPageNo() == this.readCursor.getPageNo() && this.writeCursor.getIndex() <= this.readCursor.getIndex()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)new StringBuilder("peek empty").append(", cp:").append(this.currentPage.getNo()).append(this.buildCursorLog(", wc:", this.writeCursor)).append(this.buildCursorLog(", rc:", this.readCursor)).append(this.buildCursorLog(", dc:", this.deleteCursor)));
            }
            return null;
        }
        long startIndex = this.readCursor.getIndex();
        ArrayList<String> txnIds = new ArrayList<String>();
        this.loadTxnIds(txnIds, (int)startIndex, this.readCursor.getPageNo(), bulkSize);
        if (txnIds.size() == 0 && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)new StringBuilder("_peek txnIds size is zero!").append("cp:").append(this.currentPage.getNo()).append(this.buildCursorLog(",wc:", this.writeCursor)).append(this.buildCursorLog(", rc:", this.readCursor)).append(this.buildCursorLog(", dc:", this.deleteCursor)));
        }
        ArrayList<EventSourceWrapper> list = new ArrayList<EventSourceWrapper>(txnIds.size());
        for (String txnId : txnIds) {
            EventSourceWrapper wrapper = this.get(txnId, EventSourceWrapper.class);
            list.add(wrapper);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventSourceWrapper> peek(int bulkSize) throws PersistenceException {
        ReentrantLock readLock = this.readLock;
        readLock.lock();
        try {
            List<EventSourceWrapper> list = this._peek(bulkSize);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    void loadTxnIds(List<String> txnIds, int startIndex, long pageNo, int total) throws PersistenceException {
        LevelDBPage page = this.getPage(pageNo);
        if (null == page || page.getIndexes() == null || page.getIndexes().size() == 0) {
            return;
        }
        for (int i = startIndex; i < page.getIndexes().size(); ++i) {
            txnIds.add(page.getIndexes().get(i));
            if (txnIds.size() != total) continue;
            return;
        }
        if (page.getNo() == this.currentPage.getNo()) {
            return;
        }
        long nextPageNo = page.getNo() == Long.MAX_VALUE ? 0L : page.getNo() + 1L;
        this.loadTxnIds(txnIds, 0, nextPageNo, total);
    }

    boolean isCursorToTheEndPage(LevelDBCursor c) {
        long index = c.getIndex();
        return index >= (long)this.pageSize;
    }

    void newPage(String txnId, WriteBatch wb) throws PersistenceException {
        LevelDBPage page = new LevelDBPage();
        if (this.currentPage.getNo() == Long.MAX_VALUE) {
            this.currentPage.setNo(0L);
        } else {
            page.setNo(this.currentPage.getNo() + 1L);
        }
        page.setIndexes(new ArrayList<String>());
        if (null != txnId && !"".equals(txnId)) {
            page.getIndexes().add(txnId);
        }
        this.saveRearPageNo(page.getNo(), wb);
        this.currentPage = page;
        this.savePage(this.currentPage, wb);
        this.writeCursor.setPageNo(page.getNo());
        this.writeCursor.setIndex(1L);
        this.put(KEY_WRITE_CURSOR, this.writeCursor, wb);
    }

    void saveRearPageNo(Long pageNo, WriteBatch wb) throws PersistenceException {
        this.rearPageNo = pageNo;
        this.put(KEY_REAR_PAGE_NO, this.rearPageNo, wb);
    }

    void savePage(LevelDBPage page, WriteBatch wb) throws PersistenceException {
        this.put(this.buildKey(KEY_PAGE, String.valueOf(page.getNo())), page, wb);
    }

    LevelDBPage getPage(long pageNo) throws PersistenceException {
        return this.get(this.buildKey(KEY_PAGE, String.valueOf(pageNo)), LevelDBPage.class);
    }

    public long count() {
        return this.calculateTotalCount();
    }

    public long popCount() {
        long gapPageNum = this.readCursor.getPageNo() - this.deleteCursor.getPageNo();
        long leftPageSize = this.readCursor.getIndex() - this.deleteCursor.getIndex();
        return gapPageNum * (long)this.pageSize + leftPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void houseKeeping() throws PersistenceException {
        ReentrantLock deleteLock = this.deleteLock;
        ReentrantLock readLock = this.readLock;
        if (deleteLock.tryLock()) {
            try {
                LevelDbUtils.SstFileStatisticsInfo sstFileStatisticsInfo;
                readLock.lock();
                long pageNo = this.headPageNo;
                long readPageNo = this.readCursor.getPageNo();
                long readIndex = this.readCursor.getIndex();
                try {
                    if (this.deleteCursor.getPageNo() == this.headPageNo.longValue() && this.readCursor.getPageNo() == this.deleteCursor.getPageNo() && this.deleteCursor.getIndex() == this.readCursor.getIndex()) {
                        return;
                    }
                }
                finally {
                    readLock.unlock();
                }
                int i = (int)pageNo;
                while ((long)i < readPageNo) {
                    LevelDBPage page = this.getPage(i);
                    List<String> indexes = page.getIndexes();
                    if (indexes != null && indexes.size() != 0) {
                        this.batchDelete(i, indexes.size(), indexes.toArray(new String[indexes.size()]));
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)String.format("delete data page:%s, from:%s, to:%s", readPageNo, 0, readIndex));
                        }
                    }
                    ++i;
                }
                if (readIndex > 0L) {
                    List<String> deleteIndexes;
                    LevelDBPage page = this.getPage(readPageNo);
                    int startIndex = 0;
                    if (this.deleteCursor.getPageNo() == readPageNo) {
                        startIndex = (int)this.deleteCursor.getIndex();
                    }
                    if ((deleteIndexes = page.getIndexes().subList(startIndex, (int)readIndex)).size() > 0) {
                        this.batchDelete(readPageNo, (int)readIndex, deleteIndexes.toArray(new String[deleteIndexes.size()]));
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)String.format("delete data page:%s, from:%s, to:%s", readPageNo, startIndex, readIndex));
                        }
                    }
                }
                if (pageNo < this.deleteCursor.getPageNo()) {
                    WriteBatch writeBatch = this.adapter.getDb().createWriteBatch();
                    try {
                        int i2 = (int)pageNo;
                        while ((long)i2 < this.deleteCursor.getPageNo()) {
                            String key = this.wrapperKey(this.buildKey(KEY_PAGE, String.valueOf(i2)));
                            writeBatch.delete(key.getBytes());
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)("delete page:" + key));
                            }
                            ++i2;
                        }
                        this.adapter.getDb().write(writeBatch);
                    }
                    catch (Exception e) {
                        throw new PersistenceException(e);
                    }
                    finally {
                        try {
                            writeBatch.close();
                        }
                        catch (IOException e) {
                            throw new PersistenceException(e);
                        }
                    }
                }
                if ((sstFileStatisticsInfo = LevelDbUtils.generateSstFileStatisticsInfo(this.adapter)).getFileSize() > 0x6400000L) {
                    this.adapter.getDb().compactRange(null, null);
                }
            }
            finally {
                deleteLock.unlock();
            }
        }
    }

    protected void batchDelete(long pageNo, int index, String ... keys) throws PersistenceException {
        if (keys == null || keys.length == 0 || this.adapter.getDb() == null) {
            return;
        }
        WriteBatch writeBatch = this.adapter.getDb().createWriteBatch();
        try {
            if (!this.isOpenTxn()) {
                for (String key : keys) {
                    writeBatch.delete(this.wrapperKey(key).getBytes());
                }
            }
            this.deleteCursor.setPageNo(pageNo);
            this.deleteCursor.setIndex(index);
            this.put(KEY_DELETE_CURSOR, this.deleteCursor, writeBatch);
            this.headPageNo = pageNo;
            this.put(this.buildKey(KEY_HEAD_PAGE_NO), this.headPageNo, writeBatch);
            this.adapter.getDb().write(writeBatch);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            try {
                writeBatch.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
    }

    public synchronized void clear() throws Exception {
        ReentrantLock readLock = this.readLock;
        ReentrantLock writeLock = this.writeLock;
        readLock.lock();
        writeLock.lock();
        try {
            this.adapter.clear();
            this.load();
        }
        finally {
            readLock.unlock();
            writeLock.unlock();
        }
    }

    static class QueuesStat {
        Map<String, Boolean> states = Collections.synchronizedMap(new HashMap());

        QueuesStat() {
        }
    }
}

