/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb.cache;

import eventcenter.leveldb.LevelDBPersistenceAdapter;
import eventcenter.leveldb.PersistenceException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.iq80.leveldb.WriteBatch;

public class LevelDBCache {
    static final Map<Integer, Set<String>> cacheStates = Collections.synchronizedMap(new HashMap());
    static final String SEPERATOR = "_";
    final String namespace;
    final LevelDBPersistenceAdapter adapter;

    public LevelDBCache(String namespace, LevelDBPersistenceAdapter adapter) throws PersistenceException {
        this.validateCacheStates(namespace, adapter);
        this.namespace = namespace;
        this.adapter = adapter;
    }

    void validateCacheStates(String namespace, LevelDBPersistenceAdapter adapter) throws PersistenceException {
        if (!cacheStates.containsKey(adapter.hashCode())) {
            cacheStates.put(adapter.hashCode(), new HashSet());
        }
        if (cacheStates.get(adapter.hashCode()).contains(namespace)) {
            throw new PersistenceException("leveldb cache has been contain name:" + namespace);
        }
        cacheStates.get(adapter.hashCode()).add(namespace);
    }

    String buildKey(String key) {
        return this.namespace + SEPERATOR + key;
    }

    public <T> T get(String key, Class<T> type) throws PersistenceException {
        return this.adapter.get(this.buildKey(key), type);
    }

    public void put(String key, Serializable value) throws PersistenceException {
        this.adapter.put(this.buildKey(key), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Map<String, Serializable> keyValues) throws IOException, PersistenceException {
        WriteBatch writeBatch = this.adapter.getDb().createWriteBatch();
        try {
            Set<Map.Entry<String, Serializable>> entries = keyValues.entrySet();
            for (Map.Entry<String, Serializable> entry : entries) {
                this.adapter.put(this.buildKey(entry.getKey()), entry.getValue(), writeBatch);
            }
            this.adapter.getDb().write(writeBatch);
        }
        finally {
            writeBatch.close();
        }
    }

    public void remove(String ... keys) throws PersistenceException {
        if (null == keys || keys.length == 0) {
            return;
        }
        String[] ids = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = this.buildKey(keys[i]);
        }
        this.adapter.deleteById(ids);
    }
}

