/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb.strategy;

import eventcenter.leveldb.AbstractHouseKeepingStrategy;
import eventcenter.leveldb.LevelDBQueue;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class LimitReadHouseKeepingStrategy
extends AbstractHouseKeepingStrategy {
    static final AtomicInteger count = new AtomicInteger(1);
    private int readLimitSize = 1000;
    private long checkInterval = 10000L;
    private CheckReadThread checkThread;
    private final Object locker = new Object();
    private volatile boolean open = false;

    public LimitReadHouseKeepingStrategy(LevelDBQueue queue) {
        super(queue);
    }

    @Override
    public void open() {
        this.open = true;
        this.checkThread = new CheckReadThread();
        this.checkThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.open = false;
        Object object = this.locker;
        synchronized (object) {
            this.locker.notifyAll();
        }
    }

    public int getReadLimitSize() {
        return this.readLimitSize;
    }

    public void setReadLimitSize(int readLimitSize) {
        this.readLimitSize = readLimitSize;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    class CheckReadThread
    extends Thread {
        public CheckReadThread() {
            super("hp-check-limit-thread-" + count.getAndIncrement());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (LimitReadHouseKeepingStrategy.this.open) {
                try {
                    Object object = LimitReadHouseKeepingStrategy.this.locker;
                    synchronized (object) {
                        LimitReadHouseKeepingStrategy.this.locker.wait(LimitReadHouseKeepingStrategy.this.checkInterval);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!LimitReadHouseKeepingStrategy.this.open) break;
                try {
                    long popCount = LimitReadHouseKeepingStrategy.this.queue.getQueueMiddleComponent().popCount();
                    if (popCount < (long)LimitReadHouseKeepingStrategy.this.readLimitSize) continue;
                    LimitReadHouseKeepingStrategy.this.queue.houseKeeping();
                    if (!LimitReadHouseKeepingStrategy.this.logger.isDebugEnabled()) continue;
                    LimitReadHouseKeepingStrategy.this.logger.debug((Object)("house keeping success. snapshot pop count:" + popCount));
                }
                catch (Throwable e) {
                    LimitReadHouseKeepingStrategy.this.logger.error((Object)"house keeping failure", e);
                }
            }
        }
    }
}

