/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.controller;

import eventcenter.monitor.server.model.ExecutedResponse;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class GlobalHandler {
    final Logger logger = Logger.getLogger(this.getClass());

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void aspect() {
    }

    @Around(value="aspect()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = null;
        long start = System.currentTimeMillis();
        try {
            result = joinPoint.proceed(joinPoint.getArgs());
            if (result instanceof String) {
                return result;
            }
            if (result instanceof ExecutedResponse) {
                return result;
            }
            return ExecutedResponse.buildSuccess(System.currentTimeMillis() - start, result);
        }
        catch (Exception e) {
            return ExecutedResponse.buildError(System.currentTimeMillis() - start, e.getMessage());
        }
    }
}

