/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.dao;

import com.mongodb.Block;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.IndexModel;
import eventcenter.monitor.server.dao.MongodbCollection;
import eventcenter.monitor.server.model.ContainerTrace;
import eventcenter.monitor.server.model.ContainerTraces;
import java.util.Arrays;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Repository;

@Repository
public class EventContainerTraceCollection
extends MongodbCollection {
    private final String collectionName = "containerTrace";

    @Override
    public String getCollectionName() {
        return "containerTrace";
    }

    @Override
    public void createIndexes() {
        try {
            this.getCollection().createIndexes(Arrays.asList(new IndexModel((Bson)new Document().append("nodeId", (Object)1)), new IndexModel((Bson)new Document().append("created", (Object)1))));
        }
        catch (Exception e) {
            this.logger.error((Object)("create indexes error:" + e.getMessage()), (Throwable)e);
        }
    }

    public void insert(ContainerTrace trace) {
        if (null == trace.getCreated()) {
            trace.setCreated(new Date());
        }
        this.insertOne(this.toDocument(trace));
    }

    public ContainerTraces searchWithPage(String nodeId, Integer pageNo, Integer pageSize, Date start, Date end) {
        if (null == pageNo) {
            pageNo = 1;
        }
        if (null == pageSize) {
            pageSize = 100;
        }
        Document filter = this.buildCondition(nodeId, start, end);
        FindIterable results = this.find((Bson)filter).skip((pageNo - 1) * pageSize).limit(pageSize.intValue());
        final ContainerTraces traces = new ContainerTraces();
        results.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                traces.getList().add(EventContainerTraceCollection.this.toContainerTrace(document));
            }
        });
        traces.setTotal((int)this.getCount(nodeId, start, end));
        return traces;
    }

    private long getCount(String nodeId, Date start, Date end) {
        Document filter = this.buildCondition(nodeId, start, end);
        return this.getCollection().count((Bson)filter);
    }

    private Document buildCondition(String nodeId, Date start, Date end) {
        Document filter = new Document();
        if (this.isNotEmpty(nodeId)) {
            filter.append("nodeId", (Object)nodeId);
        }
        if (null != start) {
            filter.append("created", (Object)new Document("$gte", (Object)start));
        }
        if (null != end) {
            filter.append("created", (Object)new Document("$lte", (Object)end));
        }
        return filter;
    }

    public long houseKeeping(int keepdays) {
        Date begin = new Date(System.currentTimeMillis() - (long)(keepdays * 24 * 3600 * 1000));
        return this.deleteMany((Bson)new Document("created", (Object)new Document("$lte", (Object)begin))).getDeletedCount();
    }

    private Document toDocument(ContainerTrace trace) {
        return new Document().append("nodeId", (Object)trace.getNodeId()).append("queueSize", (Object)trace.getQueueSize()).append("liveThread", (Object)trace.getCountOfLiveThread()).append("queueBuffer", (Object)trace.getCountOfQueueBuffer()).append("created", (Object)trace.getCreated());
    }

    private ContainerTrace toContainerTrace(Document doc) {
        ContainerTrace trace = new ContainerTrace();
        trace.setNodeId(doc.getString((Object)"nodeId"));
        trace.setQueueSize(doc.getInteger((Object)"queueSize"));
        trace.setCountOfQueueBuffer(doc.getInteger((Object)"queueBuffer"));
        trace.setCountOfLiveThread(doc.getInteger((Object)"liveThread"));
        trace.setCreated(doc.getDate((Object)"created"));
        return trace;
    }
}

