/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mongodb.Block;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.IndexModel;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.NodeInfo;
import eventcenter.monitor.server.dao.IndexConfigCollection;
import eventcenter.monitor.server.dao.MongodbCollection;
import eventcenter.monitor.server.dao.NodeInfoCollection;
import eventcenter.monitor.server.model.IndexConfig;
import eventcenter.monitor.server.model.MonitorEventInfoModel;
import eventcenter.monitor.server.model.MonitorEventInfoModels;
import eventcenter.monitor.server.utils.JsonRuleEngine;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Repository;

@Repository
public class EventInfoCollection
extends MongodbCollection {
    private final String collectionName = "eventInfos";
    @Resource
    private NodeInfoCollection nodeInfoCollection;
    @Resource
    private IndexConfigCollection indexConfigCollection;
    private JsonRuleEngine jsonRuleEngine = new JsonRuleEngine();

    public NodeInfoCollection getNodeInfoCollection() {
        return this.nodeInfoCollection;
    }

    public void setNodeInfoCollection(NodeInfoCollection nodeInfoCollection) {
        this.nodeInfoCollection = nodeInfoCollection;
    }

    public IndexConfigCollection getIndexConfigCollection() {
        return this.indexConfigCollection;
    }

    public void setIndexConfigCollection(IndexConfigCollection indexConfigCollection) {
        this.indexConfigCollection = indexConfigCollection;
    }

    public void insert(List<MonitorEventInfo> infos) {
        ArrayList<Document> docs = new ArrayList<Document>(infos.size() + 1);
        HashMap<String, IndexConfig> indexConfigCache = new HashMap<String, IndexConfig>();
        for (MonitorEventInfo info : infos) {
            docs.add(this.toDocument(info, indexConfigCache));
        }
        this.insertMany(docs);
    }

    @Override
    public String getCollectionName() {
        return "eventInfos";
    }

    @Override
    @PostConstruct
    public void createIndexes() {
        try {
            this.getCollection().createIndexes(Arrays.asList(new IndexModel((Bson)new Document().append("nodeId", (Object)1)), new IndexModel((Bson)new Document().append("listenerClass", (Object)1)), new IndexModel((Bson)new Document().append("eventId", (Object)1)), new IndexModel((Bson)new Document().append("fromNodeId", (Object)1)), new IndexModel((Bson)new Document().append("eventName", (Object)1)), new IndexModel((Bson)new Document().append("eventCreated", (Object)1)), new IndexModel((Bson)new Document().append("mdcValue", (Object)1)), new IndexModel((Bson)new Document().append("custom", (Object)"text"))));
        }
        catch (Exception e) {
            this.logger.error((Object)("create indexes error:" + e.getMessage()), (Throwable)e);
        }
    }

    public MonitorEventInfoModels search(String eventId, String eventName, Date start, Date end, String listenerClass, String mdcValue, String content, Integer pageNo, Integer pageSize, NodeInfo nodeInfo) {
        List<NodeInfo> nodeInfos = null;
        if (null != nodeInfo) {
            nodeInfos = this.nodeInfoCollection.search(nodeInfo);
        }
        HashMap<String, NodeInfo> filterNodeMap = new HashMap<String, NodeInfo>();
        Set<String> filterNodeIds = null;
        if (null != nodeInfos && nodeInfos.size() > 0) {
            filterNodeMap.putAll(this.toMap(nodeInfos));
            filterNodeIds = filterNodeMap.keySet();
        }
        return MonitorEventInfoModels.build((int)this.searchCount(eventId, eventName, start, end, listenerClass, mdcValue, content, nodeInfos, filterNodeMap, filterNodeIds), this._search(eventId, eventName, start, end, listenerClass, mdcValue, content, pageNo, pageSize, nodeInfos, filterNodeMap, filterNodeIds));
    }

    public MonitorEventInfoModel queryById(String id) {
        if (this.isEmpty(id)) {
            throw new IllegalArgumentException("please input id arguments");
        }
        final ArrayList result = new ArrayList(2);
        this.find((Bson)new Document("_id", (Object)new ObjectId(id))).forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                List<NodeInfo> nodes;
                String nodeId = document.getString((Object)"nodeId");
                NodeInfo nodeInfo = null;
                if (EventInfoCollection.this.isNotEmpty(nodeId) && (nodes = EventInfoCollection.this.nodeInfoCollection.queryByIds(Arrays.asList(nodeId))).size() > 0) {
                    nodeInfo = nodes.get(0);
                }
                result.add(EventInfoCollection.this.toMonitorEventInfo(document, nodeInfo));
            }
        });
        if (result.size() == 0) {
            return null;
        }
        return (MonitorEventInfoModel)result.get(0);
    }

    public long houseKeeping(int keepdays) {
        Date begin = new Date(System.currentTimeMillis() - (long)(keepdays * 24 * 3600 * 1000));
        return this.deleteMany((Bson)new Document("created", (Object)new Document("$lte", (Object)begin))).getDeletedCount();
    }

    protected List<MonitorEventInfoModel> _search(String eventId, String eventName, Date start, Date end, String listenerClass, String mdcValue, String content, Integer pageNo, Integer pageSize, List<NodeInfo> nodeInfos, final Map<String, NodeInfo> filterNodeMap, Set<String> filterNodeIds) {
        Document filter = this.buildCondition(eventId, eventName, start, end, listenerClass, mdcValue, content, nodeInfos, filterNodeMap, filterNodeIds);
        if (pageSize == null) {
            pageSize = 20;
        }
        FindIterable results = this.find((Bson)filter).limit(pageSize.intValue()).projection((Bson)new Document().append("args", (Object)0).append("result", (Object)0));
        if (null != pageNo) {
            results.skip((pageNo - 1) * pageSize);
        }
        final ArrayList<MonitorEventInfoModel> list = new ArrayList<MonitorEventInfoModel>(pageSize + 1);
        results.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                List<NodeInfo> infos;
                NodeInfo nodeInfo = (NodeInfo)filterNodeMap.get(document.getString((Object)"nodeId"));
                if (null == nodeInfo && (infos = EventInfoCollection.this.getNodeInfoCollection().queryByIds(Arrays.asList(document.getString((Object)"nodeId")))).size() > 0) {
                    nodeInfo = infos.get(0);
                    filterNodeMap.put(nodeInfo.getId(), nodeInfo);
                }
                list.add(EventInfoCollection.this.toMonitorEventInfo(document, nodeInfo));
            }
        });
        return list;
    }

    private long searchCount(String eventId, String eventName, Date start, Date end, String listenerClass, String mdcValue, String content, List<NodeInfo> nodeInfos, Map<String, NodeInfo> filterNodeMap, Set<String> filterNodeIds) {
        Document filter = this.buildCondition(eventId, eventName, start, end, listenerClass, mdcValue, content, nodeInfos, filterNodeMap, filterNodeIds);
        return this.getCollection().count((Bson)filter);
    }

    private Document buildCondition(String eventId, String eventName, Date start, Date end, String listenerClass, String mdcValue, String content, List<NodeInfo> nodeInfos, Map<String, NodeInfo> filterNodeMap, Set<String> filterNodeIds) {
        Document filter = new Document();
        if (this.isNotEmpty(eventId)) {
            filter.append("eventId", (Object)eventId);
        }
        if (this.isNotEmpty(eventName)) {
            filter.append("eventName", (Object)eventName);
        }
        if (this.isNotEmpty(listenerClass)) {
            filter.append("listenerClass", (Object)listenerClass);
        }
        if (this.isNotEmpty(mdcValue)) {
            filter.append("mdcValue", (Object)mdcValue);
        }
        if (start != null) {
            filter.append("eventCreated", (Object)new Document("$gte", (Object)start));
        }
        if (end != null) {
            filter.append("eventCreated", (Object)new Document("$lte", (Object)end));
        }
        if (null != filterNodeIds) {
            ArrayList<Document> nodeIdDocs = new ArrayList<Document>(filterNodeIds.size() + 1);
            for (String nodeId : filterNodeIds) {
                nodeIdDocs.add(new Document("nodeId", (Object)nodeId));
            }
            filter.append("$or", nodeIdDocs);
        }
        if (this.isNotEmpty(content)) {
            filter.append("$text", (Object)new Document("$search", (Object)content));
        }
        return filter;
    }

    private Map<String, NodeInfo> toMap(List<NodeInfo> infos) {
        HashMap<String, NodeInfo> map = new HashMap<String, NodeInfo>();
        for (NodeInfo info : infos) {
            map.put(info.getId(), info);
        }
        return map;
    }

    private MonitorEventInfoModel toMonitorEventInfo(Document doc, NodeInfo nodeInfo) {
        MonitorEventInfoModel info = new MonitorEventInfoModel();
        info.setId(doc.getObjectId((Object)"_id").toString());
        info.setNodeId(doc.getString((Object)"nodeId"));
        info.setEventCreate(doc.getDate((Object)"eventCreated"));
        info.setException(doc.getString((Object)"exception"));
        info.setListenerClazz(doc.getString((Object)"listenerClass"));
        info.setFromNodeId(doc.getString((Object)"fromNodeId"));
        info.setSuccess(doc.getBoolean((Object)"success"));
        info.setTook(doc.getLong((Object)"took"));
        info.setEventArgs(doc.getString((Object)"args"));
        info.setEventResult(doc.getString((Object)"result"));
        info.setEventId(doc.getString((Object)"eventId"));
        info.setEventName(doc.getString((Object)"eventName"));
        info.setMdcValue(doc.getString((Object)"mdcValue"));
        info.setEventConsumed(doc.getDate((Object)"eventConsumed"));
        if (null != nodeInfo) {
            info.setNodeName(nodeInfo.getName());
            info.setNodeGroup(nodeInfo.getGroup());
            info.setNodeHost(nodeInfo.getHost());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document toDocument(MonitorEventInfo info, Map<String, IndexConfig> indexConfigCache) {
        String excp = "";
        boolean success = true;
        if (info.getException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            try {
                info.getException().printStackTrace(writer);
            }
            finally {
                writer.close();
            }
            excp = sw.toString();
            success = false;
        }
        Document doc = new Document().append("nodeId", (Object)info.getNodeId()).append("took", (Object)info.getTook()).append("listenerClass", (Object)info.getListenerClazz()).append("exception", (Object)excp).append("success", (Object)success).append("eventId", (Object)info.getEventId()).append("fromNodeId", (Object)(info.getFromNodeId() == null ? "" : info.getFromNodeId())).append("eventName", (Object)info.getEventName()).append("eventCreated", (Object)info.getCreated()).append("eventConsumed", (Object)info.getConsumed()).append("created", (Object)new Date()).append("mdcValue", (Object)info.getMdcValue()).append("args", (Object)info.getEventArgs()).append("result", (Object)info.getEventResult());
        String customIndex = this.createCustomIndex(info, indexConfigCache);
        if (this.isEmpty(customIndex)) {
            return doc;
        }
        return doc.append("custom", (Object)customIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexConfig queryIndexConfig(MonitorEventInfo info, Map<String, IndexConfig> indexConfigCache) {
        String key = info.getNodeGroup() + "_" + info.getEventName();
        if (indexConfigCache.containsKey(key)) {
            return indexConfigCache.get(key);
        }
        IndexConfig indexConfig = this.indexConfigCollection.queryByEventName(info.getEventName(), info.getNodeGroup());
        try {
            if (null == indexConfig) {
                IndexConfig indexConfig2 = null;
                return indexConfig2;
            }
            if (this.isEmpty(info.getEventArgs()) && this.isEmpty(info.getEventResult())) {
                indexConfig = null;
                IndexConfig indexConfig3 = null;
                return indexConfig3;
            }
            IndexConfig indexConfig4 = indexConfig;
            return indexConfig4;
        }
        finally {
            indexConfigCache.put(key, indexConfig);
        }
    }

    private String createCustomIndex(MonitorEventInfo info, Map<String, IndexConfig> indexConfigCache) {
        IndexConfig indexConfig = this.queryIndexConfig(info, indexConfigCache);
        if (null == indexConfig) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isNotEmpty(info.getEventArgs()) && this.isNotEmpty(indexConfig.getArgsIndexes())) {
            this._createCustomIndex(sb, info.getEventArgs(), indexConfig.getArgsIndexes());
        }
        if (this.isNotEmpty(info.getEventResult()) && this.isNotEmpty(indexConfig.getResultIndexes())) {
            this._createCustomIndex(sb, info.getEventResult(), indexConfig.getResultIndexes());
        }
        return sb.toString();
    }

    private void _createCustomIndex(StringBuilder sb, String json, String rule) {
        if (this.isEmpty(json) || this.isEmpty(rule) || sb == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(this.jsonRuleEngine.getSeparatorChar());
        }
        try {
            sb.append(this.jsonRuleEngine.resolve((JSON)JSON.parse((String)json), rule));
        }
        catch (Exception e) {
            this.logger.error((Object)("resolve json error:" + e.getMessage()), (Throwable)e);
        }
    }

    private Document fromJSONObject(JSONObject root) {
        return new Document((Map)root);
    }

    private String toJSON(Object obj) {
        try {
            return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseISO8601DateFormat, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteClassName});
        }
        catch (Exception e) {
            this.logger.error((Object)("parse arg to json error:" + e.getMessage()), (Throwable)e);
            return "";
        }
    }
}

