/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.dao;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class MongodbCollection {
    protected final Logger logger = Logger.getLogger(this.getClass());
    @Resource
    protected MongoDatabase db;

    protected MongoCollection<Document> getCollection() {
        return this.db.getCollection(this.getCollectionName());
    }

    protected void insertOne(Document doc) {
        this.getCollection().insertOne((Object)doc);
    }

    protected void insertMany(List<? extends Document> list) {
        this.getCollection().insertMany(list);
    }

    protected UpdateResult updateOne(Bson filter, Bson update) {
        return this.getCollection().updateOne(filter, update);
    }

    protected UpdateResult updateMany(Bson filter, Bson update) {
        return this.getCollection().updateMany(filter, update);
    }

    protected DeleteResult deleteMany(Bson filter) {
        return this.getCollection().deleteMany(filter);
    }

    protected DeleteResult deleteOne(Bson filter) {
        return this.getCollection().deleteOne(filter);
    }

    protected FindIterable<Document> find(Bson filter) {
        return this.getCollection().find(filter);
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public void setDb(MongoDatabase db) {
        this.db = db;
    }

    public abstract String getCollectionName();

    public abstract void createIndexes();

    protected boolean isEmpty(String value) {
        return null == value || "".equals(value);
    }

    protected boolean isNotEmpty(String value) {
        return !this.isEmpty(value);
    }
}

