/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.List;

public class MongodbClientFactory {
    private MongoClient mongoClient;
    private MongoDatabase db;
    private String host;
    private Integer port;
    private String databaseName;
    private MongoClientOptions options;
    private List<MongoCredential> credentials;

    public MongoDatabase initConnections() {
        if (null == this.databaseName || "".equals(this.databaseName.trim())) {
            throw new IllegalArgumentException("please set databaseName arguments");
        }
        if (null != this.db) {
            return this.db;
        }
        this.initMongoClient();
        this.db = this.mongoClient.getDatabase(this.databaseName);
        return this.db;
    }

    protected void initMongoClient() {
        ServerAddress address = null;
        address = !this.isEmpty(this.host) ? (null == this.port ? new ServerAddress(this.host) : new ServerAddress(this.host, this.port.intValue())) : new ServerAddress();
        if (null == this.options) {
            this.options = new MongoClientOptions.Builder().build();
        }
        this.mongoClient = null == this.credentials ? new MongoClient(address, this.options) : new MongoClient(address, this.credentials, this.options);
    }

    public void destroy() {
        if (null == this.mongoClient) {
            return;
        }
        this.mongoClient.close();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public MongoClientOptions getOptions() {
        return this.options;
    }

    public void setOptions(MongoClientOptions options) {
        this.options = options;
    }

    public List<MongoCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<MongoCredential> credentials) {
        this.credentials = credentials;
    }

    protected boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }
}

