package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.remote.EventTransmission;
import eventcenter.remote.dubbo.DubboRemoteFactoryBase;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.utils.StringHelper;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * 构建{@link PublisherGroup}的工厂
 * @author JackyLIU
 *
 */
public class PublisherGroupFactory extends DubboRemoteFactoryBase {

	private ReferenceConfig<EventTransmission> referenceConfig;
	
	/**
	 * 连接dubbo远程服务端的地址，如果配置了registerConfig可以不用设置这个
	 */
	private String url;
	
	/**
	 * 需要发送到远程事件的事件名称，多个事件名称使用','符号分割
	 */
	private String remoteEvents;

	/**
	 * publish group name
	 */
	private String name;
	
	private PublisherGroup publisherGroup;
	
	private ReferenceConfig<EventTransmission> instanceRefConfig;

	private static DubboCallback callback = new DubboCallback();
	
	private final Logger logger = Logger.getLogger(this.getClass());
	
	/**
	 * 创建的PublisherGroup为单例模式，如果需要重新创建，则应该先
	 * @return
	 */
	public PublisherGroup createPublisherGroup(){
		if(null == publisherGroup) {
			instanceRefConfig = getReferenceConfig();

			if(StringHelper.isNotEmpty(getVersion())) {
				instanceRefConfig.setVersion(getVersion());
			}

			if(null != getApplicationConfig()) {
				instanceRefConfig.setApplication(getApplicationConfig());
			}
			if(null != getRegistryConfig()) {
				instanceRefConfig.setRegistry(getRegistryConfig());
			}
			if(StringHelper.isNotEmpty(url)) {
				instanceRefConfig.setUrl(url);
			}
			instanceRefConfig.setInterface(EventTransmission.class);
			instanceRefConfig.setCheck(false);
			//initRefMethod(instanceRefConfig);
			EventTransmission et = instanceRefConfig.get();
			publisherGroup = new PublisherGroup(name, et);
		}
		publisherGroup.setRemoteEvents(remoteEvents);
		return publisherGroup;
	}

	protected void initRefMethod(final ReferenceConfig<EventTransmission> config){
		List<MethodConfig> methods = new ArrayList<MethodConfig>(1);
		MethodConfig methodConfig = new MethodConfig();
		methodConfig.setAsync(true);
		methodConfig.setName("asyncTransmission");
		methodConfig.setOnreturn(callback);
		methodConfig.setOnreturnMethod("OnReturn");
		methodConfig.setOnthrow(callback);
		methodConfig.setOnthrowMethod("OnThrow");
		methods.add(methodConfig);
		config.setMethods(methods);
	}
	
	public synchronized boolean destroy(){
		if(null == publisherGroup) {
			return false;
		}
		
		try{
			if(null != instanceRefConfig) {
				instanceRefConfig.destroy();
			}
		}catch(Exception e){
			logger.error(e.getMessage(), e);
		}
		publisherGroup = null;
		return true;
	}

	public ReferenceConfig<EventTransmission> getReferenceConfig() {
		if(null == referenceConfig) {
			referenceConfig = new ReferenceConfig<EventTransmission>();
		}
		return referenceConfig;
	}

	public void setReferenceConfig(
			ReferenceConfig<EventTransmission> referenceConfig) {
		this.referenceConfig = referenceConfig;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getRemoteEvents() {
		return remoteEvents;
	}

	public void setRemoteEvents(String remoteEvents) {
		this.remoteEvents = remoteEvents;
	}

	public static PublisherGroupFactory buildWith(URL url, String remoteEvents){
		PublisherGroupFactory factory = buildWith(url, remoteEvents, null);
		factory.getReferenceConfig().setUrl(new StringBuilder("dubbo://").append(url.getHost()).append(":").append(url.getPort()).toString());
		return factory;
	}

	public static PublisherGroupFactory buildWith(URL url, String remoteEvents, RegistryConfig registry){
		PublisherGroupFactory factory = new PublisherGroupFactory();
		factory.setApplicationConfig(createApplicationConfig(url));
		factory.setVersion(url.getParameter("version"));
		factory.setRemoteEvents(remoteEvents);
		factory.setRegistryConfig(registry);
		factory.getReferenceConfig().setGroup(url.getParameter("group"));
		factory.setName(buildPublisherGroupName(url));
		return factory;
	}

	public static String buildPublisherGroupName(URL url){
		return new StringBuilder(url.getParameter("group")).append("_").append(url.getParameter("version")).toString();
	}

	void setPublisherGroup(PublisherGroup publisherGroup) {
		this.publisherGroup = publisherGroup;
	}
}
