package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.remote.EventSubscriber;
import eventcenter.remote.dubbo.DubboRemoteFactoryBase;
import eventcenter.remote.utils.StringHelper;
import org.apache.log4j.Logger;

/**
 * 创建{@link EventSubscriber}调用代理的工厂
 * @author JackyLIU
 *
 */
public class RemoteSubscriberFactory extends DubboRemoteFactoryBase {

	private ReferenceConfig<EventSubscriber> referenceConfig;
	
	/**
	 * 连接dubbo远程服务端的地址，如果配置了registerConfig可以不用设置这个
	 */
	private String url;
	
	private EventSubscriber eventSubscriber;
	
	private ReferenceConfig<EventSubscriber> instanceRefConfig;

	private ApplicationConfig applicationConfig;
	
	private final Logger logger = Logger.getLogger(this.getClass());
	
	public synchronized EventSubscriber createEventSubscriber(){
		if(null != eventSubscriber) {
			return eventSubscriber;
		}
		
		instanceRefConfig = getReferenceConfig();
		
		if(StringHelper.isNotEmpty(getVersion())) {
			instanceRefConfig.setVersion(getVersion());
		}
		
		if(null != getApplicationConfig()) {
			instanceRefConfig.setApplication(getApplicationConfig());
		}
		if(null != getRegistryConfig()) {
			instanceRefConfig.setRegistry(getRegistryConfig());
		}
		if(StringHelper.isNotEmpty(url)) {
			instanceRefConfig.setUrl(url);
		}
		instanceRefConfig.setInterface(EventSubscriber.class);
		instanceRefConfig.setCheck(false);

		eventSubscriber = instanceRefConfig.get();

		return eventSubscriber;
	}

	/**
	 * 销毁创建的EventSubscriber
	 */
	public void destroyEventSubscriber(){
		if(null == instanceRefConfig){
			return ;
		}

		instanceRefConfig.destroy();
	}
	
	public synchronized boolean destroy(){
		if(null == eventSubscriber) {
			return false;
		}
		
		try{
			if(null != instanceRefConfig) {
				instanceRefConfig.destroy();
			}
		}catch(Exception e){
			logger.error(e.getMessage(), e);
		}
		eventSubscriber = null;
		return true;
	}
	
	public ReferenceConfig<EventSubscriber> getReferenceConfig() {
		if(null == referenceConfig) {
			referenceConfig = new ReferenceConfig<EventSubscriber>();
		}
		return referenceConfig;
	}

	public void setReferenceConfig(
			ReferenceConfig<EventSubscriber> referenceConfig) {
		this.referenceConfig = referenceConfig;
	}

	public static RemoteSubscriberFactory buildWith(URL url, RegistryConfig registryConfig){
		RemoteSubscriberFactory factory = new RemoteSubscriberFactory();
		factory.setApplicationName(url.getParameter("application"));
		factory.setVersion(url.getParameter("version"));
		if(null != registryConfig){
			registryConfig.setRegister(false);
		}
		factory.setApplicationConfig(createApplicationConfig(url));
		factory.setRegistryConfig(registryConfig);
		factory.getReferenceConfig().setGroup(url.getParameter("group"));
		return factory;
	}

	void setEventSubscriber(EventSubscriber eventSubscriber) {
		this.eventSubscriber = eventSubscriber;
	}
}
