package eventcenter.remote.dubbo.subscriber.watchdog;

import com.alibaba.dubbo.common.URL;
import eventcenter.remote.EventSubscriber;
import eventcenter.remote.SubscriberGroup;

/**
 * 这个接口一般被{@link SubscriberWatchDog}监听使用，如果看门狗检测到{@link EventSubscriber}能够被调用成功，则执行这个回调接口
 * @author liumingjian
 * @date 2018/9/17
 **/
public interface SubscriberAware {

    /**
     * 看门狗检测心跳，主要调用{@link EventSubscriber#getSubscriberGroup(String)}获取到其中的远程订阅事件
     */
    void checkRemoteEventsSuccess(EventSubscriber eventSubscriber, URL url, SubscriberGroup subscriberGroup);

    /**
     * 看门狗检测的{@link EventSubscriber}过期了，最后会调用这个方法
     * @param eventSubscriber
     * @param url
     */
    void expiried(EventSubscriber eventSubscriber, URL url);
}
