/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.remote.utils.StringHelper;

public class DubboRemoteFactoryBase {
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ProtocolConfig protocolConfig;
    private String applicationName;
    private String registryAddress;
    private String registryProtocol;
    private Integer registryPort;
    private String protocolName;
    private Integer protocolPort;
    private Integer protocolThreads;
    private String version;

    public ApplicationConfig getApplicationConfig() {
        if (null == this.applicationConfig) {
            if (StringHelper.isEmpty((String)this.applicationName)) {
                return this.applicationConfig;
            }
            this.applicationConfig = new ApplicationConfig(this.applicationName);
        }
        return this.applicationConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public RegistryConfig getRegistryConfig() {
        if (null == this.registryConfig) {
            if (StringHelper.isEmpty((String)this.registryAddress)) {
                return this.registryConfig;
            }
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setAddress(this.registryAddress);
            this.registryConfig.setRegister(Boolean.valueOf(false));
            if (StringHelper.isNotEmpty((String)this.registryProtocol)) {
                this.registryConfig.setProtocol(this.registryProtocol);
            }
            if (null != this.registryPort) {
                this.registryConfig.setPort(this.registryPort);
            }
        }
        return this.registryConfig;
    }

    public void setRegistryConfig(RegistryConfig registryConfig) {
        this.registryConfig = registryConfig;
    }

    public ProtocolConfig getProtocolConfig() {
        if (null == this.protocolConfig) {
            this.protocolConfig = new ProtocolConfig();
            if (StringHelper.isNotEmpty((String)this.protocolName)) {
                this.protocolConfig.setName(this.protocolName);
            }
            if (null != this.protocolPort) {
                this.protocolConfig.setPort(this.protocolPort);
            }
            if (null != this.protocolThreads) {
                this.protocolConfig.setThreads(this.protocolThreads);
            }
        }
        return this.protocolConfig;
    }

    public void setProtocolConfig(ProtocolConfig protocolConfig) {
        this.protocolConfig = protocolConfig;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    public void setProtocolPort(Integer protocolPort) {
        this.protocolPort = protocolPort;
    }

    public Integer getProtocolThreads() {
        return this.protocolThreads;
    }

    public void setProtocolThreads(Integer protocolThreads) {
        this.protocolThreads = protocolThreads;
    }

    public String getRegistryAddress() {
        return this.registryAddress;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public String getRegistryProtocol() {
        return this.registryProtocol;
    }

    public void setRegistryProtocol(String registryProtocol) {
        this.registryProtocol = registryProtocol;
    }

    public Integer getRegistryPort() {
        return this.registryPort;
    }

    public void setRegistryPort(Integer registryPort) {
        this.registryPort = registryPort;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected static ApplicationConfig createApplicationConfig(URL url) {
        ApplicationConfig config = new ApplicationConfig();
        String application = url.getParameter("application");
        String owner = url.getParameter("owner");
        String organization = url.getParameter("organization");
        config.setName(application);
        config.setOwner(owner);
        config.setOrganization(organization);
        return config;
    }
}

