/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.RegistryService;
import eventcenter.remote.EventPublisher;
import eventcenter.remote.EventSubscriber;
import eventcenter.remote.dubbo.publisher.RegistryServiceFactory;
import eventcenter.remote.dubbo.publisher.SubcriberHolder;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.saf.EventForward;
import eventcenter.remote.saf.PublishGroupChangeable;
import eventcenter.remote.saf.StoreAndForwardPolicy;
import eventcenter.remote.utils.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DubboRegistryEventPublisher
implements EventPublisher,
PublishGroupChangeable,
ApplicationContextAware {
    public static final String REGISTRY_ADDRESS = "dubbo.registry.address";
    public static final String APPLICATION_NAME = "dubbo.application.name";
    private String dubboGroup;
    @Autowired(required=false)
    private RegistryService registryService;
    private ApplicationContext applicationContext;
    SubcriberHolder subcriberHolder = new SubcriberHolder();
    protected List<PublisherGroup> localPublisherGroups = null;
    protected Map<String, List<URL>> serviceProviders = new ConcurrentHashMap<String, List<URL>>();
    private final Logger logger = Logger.getLogger(this.getClass());
    RegistryConfig registryConfig;
    private String registryUrl;

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
        this.subcriberHolder.setRegistryConfig(this.registryConfig);
    }

    public boolean isCopySendUnderSameVersion() {
        return this.subcriberHolder.isCopySendUnderSameVersion();
    }

    public void setCopySendUnderSameVersion(boolean copySendUnderSameVersion) {
        this.subcriberHolder.setCopySendUnderSameVersion(copySendUnderSameVersion);
    }

    public boolean isDevMode() {
        return this.subcriberHolder.isDevMode();
    }

    public void setDevMode(boolean devMode) {
        this.subcriberHolder.setDevMode(devMode);
    }

    public String getDubboGroup() {
        return this.dubboGroup;
    }

    public void setDubboGroup(String dubboGroup) {
        this.dubboGroup = dubboGroup;
    }

    public void startup() {
        if (null == this.registryService && this.applicationContext != null) {
            this.registryService = RegistryServiceFactory.buildDefault(this.applicationContext);
        }
        if (this.applicationContext != null && null == this.registryConfig) {
            try {
                this.registryConfig = (RegistryConfig)this.applicationContext.getBean(RegistryConfig.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.subcriberHolder.getLocalSubscriberId() == null && this.applicationContext != null) {
            try {
                EventSubscriber localEventSubscriber = (EventSubscriber)this.applicationContext.getBean(EventSubscriber.class);
                this.subcriberHolder.setLocalSubscriberId(localEventSubscriber.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dubboGroup == null || this.dubboGroup.length() == 0) {
            throw new IllegalArgumentException("Please set dubboGroup property");
        }
        this.subcriberHolder.setDubboGroup(this.dubboGroup);
        this.initRegistryService();
    }

    void initRegistryService() {
        if (this.registryConfig == null) {
            String url;
            String string = url = StringHelper.isNotEmpty((String)this.registryUrl) ? this.registryUrl : ConfigUtils.getProperty((String)REGISTRY_ADDRESS);
            if (url == null || url.length() == 0) {
                throw new IllegalArgumentException("Please set java start argument: -Ddubbo.registry.address=zookeeper://127.0.0.1:2181");
            }
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setAddress(url);
            this.registryConfig.setRegister(Boolean.valueOf(false));
        }
        this.subcriberHolder.setRegistryConfig(this.registryConfig);
        URL eventSubscriberUrl = new URL("admin", NetUtils.getLocalHost(), 0, "", new String[]{"interface", EventSubscriber.class.getName(), "group", this.dubboGroup, "version", "*", "classifier", "*", "category", "providers", "check", String.valueOf(false)});
        this.registryService.subscribe(eventSubscriberUrl, this.createNotifyListener());
        this.logger.info((Object)("startup dubbo registry success, group:" + this.dubboGroup));
    }

    NotifyListener createNotifyListener() {
        return new NotifyListener(){

            public void notify(List<URL> urls) {
                DubboRegistryEventPublisher.this._notify(urls);
            }
        };
    }

    protected void _notify(List<URL> urls) {
        if (urls == null || urls.size() == 0) {
            return;
        }
        HashMap<String, List<URL>> providerMap = new HashMap<String, List<URL>>();
        for (URL url : urls) {
            String category = url.getParameter("category", "providers");
            if (!"providers".equals(category)) continue;
            String service = url.getServiceInterface();
            if (!EventSubscriber.class.getName().equals(service)) continue;
            if ("empty".equals(url.getProtocol())) {
                this.destroyAllSubscribers(service);
                return;
            }
            ArrayList<URL> list = (ArrayList<URL>)providerMap.get(service);
            if (list == null) {
                list = new ArrayList<URL>();
                providerMap.put(service, list);
            }
            list.add(url);
        }
        List<URL> offlineProviders = this.findOfflineProviders((List)providerMap.get(EventSubscriber.class.getName()));
        this.serviceProviders.putAll(providerMap);
        if (offlineProviders != null && offlineProviders.size() > 0) {
            this.subcriberHolder.destroySubscribers(offlineProviders);
        }
        this.loadSubscriber(providerMap);
    }

    protected List<URL> findOfflineProviders(List<URL> urls) {
        if (!this.serviceProviders.containsKey(EventSubscriber.class.getName())) {
            return null;
        }
        List<URL> localUrls = this.serviceProviders.get(EventSubscriber.class.getName());
        Map<String, URL> remoteMap = this.toMap(urls);
        ArrayList<URL> offlines = new ArrayList<URL>();
        for (URL localUrl : localUrls) {
            if (remoteMap.containsKey(this.subcriberHolder.createAddress(localUrl))) continue;
            offlines.add(localUrl);
        }
        return offlines;
    }

    private Map<String, URL> toMap(List<URL> urls) {
        HashMap<String, URL> map = new HashMap<String, URL>(urls.size());
        for (URL url : urls) {
            map.put(this.subcriberHolder.createAddress(url), url);
        }
        return map;
    }

    public void shutdown() {
        this.subcriberHolder.shutdown();
    }

    protected void loadSubscriber(Map<String, List<URL>> providerMap) {
        if (providerMap.containsKey(EventSubscriber.class.getName())) {
            this.loadEventSubscriber(providerMap.get(EventSubscriber.class.getName()), null);
        }
    }

    protected void loadEventSubscriber(List<URL> urls, List<String> remoteEventsList) {
        if (null == urls || urls.size() == 0) {
            return;
        }
        for (int i = 0; i < urls.size(); ++i) {
            URL url = urls.get(i);
            try {
                this.subcriberHolder.loadEventSubscriber(url);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void destroyAllSubscribers(String service) {
        if (this.serviceProviders == null || this.serviceProviders.size() == 0) {
            return;
        }
        List<URL> urls = this.serviceProviders.get(service);
        this.subcriberHolder.destroySubscribers(urls);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void publish(List<PublisherGroup> groups) {
        if (null == this.localPublisherGroups) {
            this.localPublisherGroups = new ArrayList<PublisherGroup>();
        }
        this.localPublisherGroups.addAll(groups);
    }

    public List<PublisherGroup> getPublisherGroups() {
        ArrayList<PublisherGroup> groups = new ArrayList<PublisherGroup>(this.subcriberHolder.getPublisherGroups().values());
        if (this.localPublisherGroups != null && this.localPublisherGroups.size() > 0) {
            groups.addAll(this.localPublisherGroups);
        }
        return groups;
    }

    public void setExpiryOffline(int expiryOffline) {
        this.subcriberHolder.setExpiryOffline(expiryOffline);
    }

    public int getExpiryOffline() {
        return this.subcriberHolder.getExpiryOffline();
    }

    public void setForwardAndStorePolicy(EventForward eventForward, StoreAndForwardPolicy policy) {
        this.subcriberHolder.setEventForward(eventForward);
        this.subcriberHolder.setStoreAndForwardPolicy(policy);
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void copy2RegistryConfig(RegistryConfig config) {
        if (null == this.registryConfig) {
            this.registryConfig = new RegistryConfig();
        }
        if (StringHelper.isNotEmpty((String)config.getAddress())) {
            this.registryConfig.setAddress(config.getAddress());
        }
        if (StringHelper.isNotEmpty((String)config.getClient())) {
            this.registryConfig.setClient(config.getClient());
        }
        if (StringHelper.isNotEmpty((String)config.getCluster())) {
            this.registryConfig.setCluster(config.getCluster());
        }
        if (StringHelper.isNotEmpty((String)config.getFile())) {
            this.registryConfig.setFile(config.getFile());
        }
        if (StringHelper.isNotEmpty((String)config.getGroup())) {
            this.registryConfig.setGroup(config.getGroup());
        }
        if (StringHelper.isNotEmpty((String)config.getPassword())) {
            this.registryConfig.setPassword(config.getPassword());
        }
        if (StringHelper.isNotEmpty((String)config.getProtocol())) {
            this.registryConfig.setProtocol(config.getProtocol());
        }
        if (StringHelper.isNotEmpty((String)config.getServer())) {
            this.registryConfig.setServer(config.getServer());
        }
        if (StringHelper.isNotEmpty((String)config.getTransporter())) {
            this.registryConfig.setTransporter(config.getTransporter());
        }
        if (StringHelper.isNotEmpty((String)config.getUsername())) {
            this.registryConfig.setUsername(config.getUsername());
        }
        if (StringHelper.isNotEmpty((String)config.getVersion())) {
            this.registryConfig.setVersion(config.getVersion());
        }
        if (StringHelper.isNotEmpty((String)config.getId())) {
            this.registryConfig.setId(config.getId());
        }
        if (null != config.getParameters()) {
            this.registryConfig.setParameters(config.getParameters());
        }
        if (null != config.getPort()) {
            this.registryConfig.setPort(config.getPort());
        }
        if (null != config.getSession()) {
            this.registryConfig.setSession(config.getSession());
        }
        if (null != config.getTimeout()) {
            this.registryConfig.setTimeout(config.getTimeout());
        }
    }

    public String getLocalSubscriberId() {
        return this.subcriberHolder.getLocalSubscriberId();
    }

    public void setLocalSubscriberId(String localSubscriberId) {
        this.subcriberHolder.setLocalSubscriberId(localSubscriberId);
    }
}

