/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.remote.EventTransmission;
import eventcenter.remote.dubbo.DubboRemoteFactoryBase;
import eventcenter.remote.dubbo.publisher.DubboCallback;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.utils.StringHelper;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PublisherGroupFactory
extends DubboRemoteFactoryBase {
    private ReferenceConfig<EventTransmission> referenceConfig;
    private String url;
    private String remoteEvents;
    private String name;
    private PublisherGroup publisherGroup;
    private ReferenceConfig<EventTransmission> instanceRefConfig;
    private static DubboCallback callback = new DubboCallback();
    private final Logger logger = Logger.getLogger(this.getClass());

    public PublisherGroup createPublisherGroup() {
        if (null == this.publisherGroup) {
            this.instanceRefConfig = this.getReferenceConfig();
            if (StringHelper.isNotEmpty((String)this.getVersion())) {
                this.instanceRefConfig.setVersion(this.getVersion());
            }
            if (null != this.getApplicationConfig()) {
                this.instanceRefConfig.setApplication(this.getApplicationConfig());
            }
            if (null != this.getRegistryConfig()) {
                this.instanceRefConfig.setRegistry(this.getRegistryConfig());
            }
            if (StringHelper.isNotEmpty((String)this.url)) {
                this.instanceRefConfig.setUrl(this.url);
            }
            this.instanceRefConfig.setInterface(EventTransmission.class);
            this.instanceRefConfig.setCheck(Boolean.valueOf(false));
            EventTransmission et = (EventTransmission)this.instanceRefConfig.get();
            this.publisherGroup = new PublisherGroup(this.name, et);
        }
        this.publisherGroup.setRemoteEvents(this.remoteEvents);
        return this.publisherGroup;
    }

    protected void initRefMethod(ReferenceConfig<EventTransmission> config) {
        ArrayList<MethodConfig> methods = new ArrayList<MethodConfig>(1);
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setAsync(Boolean.valueOf(true));
        methodConfig.setName("asyncTransmission");
        methodConfig.setOnreturn((Object)callback);
        methodConfig.setOnreturnMethod("OnReturn");
        methodConfig.setOnthrow((Object)callback);
        methodConfig.setOnthrowMethod("OnThrow");
        methods.add(methodConfig);
        config.setMethods(methods);
    }

    public synchronized boolean destroy() {
        if (null == this.publisherGroup) {
            return false;
        }
        try {
            if (null != this.instanceRefConfig) {
                this.instanceRefConfig.destroy();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publisherGroup = null;
        return true;
    }

    public ReferenceConfig<EventTransmission> getReferenceConfig() {
        if (null == this.referenceConfig) {
            this.referenceConfig = new ReferenceConfig();
        }
        return this.referenceConfig;
    }

    public void setReferenceConfig(ReferenceConfig<EventTransmission> referenceConfig) {
        this.referenceConfig = referenceConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRemoteEvents() {
        return this.remoteEvents;
    }

    public void setRemoteEvents(String remoteEvents) {
        this.remoteEvents = remoteEvents;
    }

    public static PublisherGroupFactory buildWith(URL url, String remoteEvents) {
        PublisherGroupFactory factory = PublisherGroupFactory.buildWith(url, remoteEvents, null);
        factory.getReferenceConfig().setUrl("dubbo://" + url.getHost() + ":" + url.getPort());
        return factory;
    }

    public static PublisherGroupFactory buildWith(URL url, String remoteEvents, RegistryConfig registry) {
        PublisherGroupFactory factory = new PublisherGroupFactory();
        factory.setApplicationConfig(PublisherGroupFactory.createApplicationConfig(url));
        factory.setVersion(url.getParameter("version"));
        factory.setRemoteEvents(remoteEvents);
        factory.setRegistryConfig(registry);
        factory.getReferenceConfig().setGroup(url.getParameter("group"));
        factory.setName(PublisherGroupFactory.buildPublisherGroupName(url));
        return factory;
    }

    public static String buildPublisherGroupName(URL url) {
        return url.getParameter("group") + "_" + url.getParameter("version");
    }

    void setPublisherGroup(PublisherGroup publisherGroup) {
        this.publisherGroup = publisherGroup;
    }
}

