/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.publisher;

import eventcenter.remote.dubbo.publisher.PublisherGroupFactory;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.utils.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PublisherGroupsFactory
extends PublisherGroupFactory {
    private List<PublisherGroupFactory> publisherGroupFactories;

    public List<PublisherGroup> createPublisherGroups() {
        if (this.getPublisherGroupFactories().size() == 0) {
            PublisherGroupFactory factory = new PublisherGroupFactory();
            return Arrays.asList(this.assembly(factory).createPublisherGroup());
        }
        ArrayList<PublisherGroup> groups = new ArrayList<PublisherGroup>();
        for (PublisherGroupFactory factory : this.getPublisherGroupFactories()) {
            groups.add(this.assembly(factory).createPublisherGroup());
        }
        return groups;
    }

    private PublisherGroupFactory assembly(PublisherGroupFactory factory) {
        if (this.getApplicationConfig() != null) {
            factory.setApplicationConfig(this.getApplicationConfig());
        }
        if (this.getRegistryConfig() != null) {
            factory.setRegistryConfig(this.getRegistryConfig());
        }
        if (this.getProtocolConfig() != null) {
            factory.setProtocolConfig(this.getProtocolConfig());
        }
        if (StringHelper.isNotEmpty((String)this.getVersion())) {
            factory.setVersion(this.getVersion());
        }
        if (StringHelper.isNotEmpty((String)this.getUrl())) {
            factory.setUrl(this.getUrl());
        }
        if (StringHelper.isNotEmpty((String)this.getRemoteEvents())) {
            factory.setRemoteEvents(this.getRemoteEvents());
        }
        return factory;
    }

    public List<PublisherGroupFactory> getPublisherGroupFactories() {
        if (null == this.publisherGroupFactories) {
            this.publisherGroupFactories = new ArrayList<PublisherGroupFactory>();
        }
        return this.publisherGroupFactories;
    }

    public void setPublisherGroupFactories(List<PublisherGroupFactory> publisherGroupFactories) {
        this.publisherGroupFactories = publisherGroupFactories;
    }
}

