/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.registry.RegistryService;
import eventcenter.remote.dubbo.DubboRemoteFactoryBase;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class RegistryServiceFactory
extends DubboRemoteFactoryBase {
    private ReferenceConfig<RegistryService> referenceConfig;

    public RegistryService createRegistryService() {
        return (RegistryService)this.getReferenceConfig().get();
    }

    public static RegistryService buildDefault(ApplicationContext applicationContext) {
        try {
            return (RegistryService)applicationContext.getBean(RegistryService.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            ReferenceConfig config = new ReferenceConfig();
            try {
                ApplicationConfig applicationConfig = (ApplicationConfig)applicationContext.getBean(ApplicationConfig.class);
                config.setApplication(applicationConfig);
            }
            catch (NoSuchBeanDefinitionException applicationConfig) {
                // empty catch block
            }
            try {
                RegistryConfig registryConfig = (RegistryConfig)applicationContext.getBean(RegistryConfig.class);
                config.setRegistry(registryConfig);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException2) {
                // empty catch block
            }
            config.setInterface(RegistryService.class);
            config.setId("registryService" + System.currentTimeMillis());
            return (RegistryService)config.get();
        }
    }

    public static RegistryServiceFactory buildWith(URL url, String applicationName) {
        RegistryServiceFactory factory = RegistryServiceFactory.buildWith(url, applicationName, null);
        factory.getReferenceConfig().setUrl("dubbo://" + url.getHost() + ":" + url.getPort());
        return factory;
    }

    public static RegistryServiceFactory buildWith(URL url, String applicationName, RegistryConfig registryConfig) {
        RegistryServiceFactory factory = new RegistryServiceFactory();
        factory.setApplicationName(applicationName);
        factory.setVersion(url.getParameter("version"));
        factory.setRegistryConfig(registryConfig);
        factory.getReferenceConfig().setGroup(url.getParameter("group"));
        return factory;
    }

    public static RegistryServiceFactory buildWith(ReferenceConfig<RegistryService> registryServiceConfig) {
        RegistryServiceFactory factory = new RegistryServiceFactory();
        factory.setReferenceConfig(registryServiceConfig);
        return factory;
    }

    public ReferenceConfig<RegistryService> getReferenceConfig() {
        if (null == this.referenceConfig) {
            this.referenceConfig = new ReferenceConfig();
        }
        return this.referenceConfig;
    }

    public void setReferenceConfig(ReferenceConfig<RegistryService> referenceConfig) {
        this.referenceConfig = referenceConfig;
    }
}

