/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.remote.EventSubscriber;
import eventcenter.remote.dubbo.DubboRemoteFactoryBase;
import eventcenter.remote.utils.StringHelper;
import org.apache.log4j.Logger;

public class RemoteSubscriberFactory
extends DubboRemoteFactoryBase {
    private ReferenceConfig<EventSubscriber> referenceConfig;
    private String url;
    private EventSubscriber eventSubscriber;
    private ReferenceConfig<EventSubscriber> instanceRefConfig;
    private ApplicationConfig applicationConfig;
    private final Logger logger = Logger.getLogger(this.getClass());

    public synchronized EventSubscriber createEventSubscriber() {
        if (null != this.eventSubscriber) {
            return this.eventSubscriber;
        }
        this.instanceRefConfig = this.getReferenceConfig();
        if (StringHelper.isNotEmpty((String)this.getVersion())) {
            this.instanceRefConfig.setVersion(this.getVersion());
        }
        if (null != this.getApplicationConfig()) {
            this.instanceRefConfig.setApplication(this.getApplicationConfig());
        }
        if (null != this.getRegistryConfig()) {
            this.instanceRefConfig.setRegistry(this.getRegistryConfig());
        }
        if (StringHelper.isNotEmpty((String)this.url)) {
            this.instanceRefConfig.setUrl(this.url);
        }
        this.instanceRefConfig.setInterface(EventSubscriber.class);
        this.instanceRefConfig.setCheck(Boolean.valueOf(false));
        this.eventSubscriber = (EventSubscriber)this.instanceRefConfig.get();
        return this.eventSubscriber;
    }

    public void destroyEventSubscriber() {
        if (null == this.instanceRefConfig) {
            return;
        }
        this.instanceRefConfig.destroy();
    }

    public synchronized boolean destroy() {
        if (null == this.eventSubscriber) {
            return false;
        }
        try {
            if (null != this.instanceRefConfig) {
                this.instanceRefConfig.destroy();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.eventSubscriber = null;
        return true;
    }

    public ReferenceConfig<EventSubscriber> getReferenceConfig() {
        if (null == this.referenceConfig) {
            this.referenceConfig = new ReferenceConfig();
        }
        return this.referenceConfig;
    }

    public void setReferenceConfig(ReferenceConfig<EventSubscriber> referenceConfig) {
        this.referenceConfig = referenceConfig;
    }

    public static RemoteSubscriberFactory buildWith(URL url, RegistryConfig registryConfig) {
        RemoteSubscriberFactory factory = new RemoteSubscriberFactory();
        factory.setApplicationName(url.getParameter("application"));
        factory.setVersion(url.getParameter("version"));
        if (null != registryConfig) {
            registryConfig.setRegister(Boolean.valueOf(false));
        }
        factory.setApplicationConfig(RemoteSubscriberFactory.createApplicationConfig(url));
        factory.setRegistryConfig(registryConfig);
        factory.getReferenceConfig().setGroup(url.getParameter("group"));
        return factory;
    }

    void setEventSubscriber(EventSubscriber eventSubscriber) {
        this.eventSubscriber = eventSubscriber;
    }
}

