/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.publisher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.config.RegistryConfig;
import eventcenter.remote.EventSubscriber;
import eventcenter.remote.SubscriberGroup;
import eventcenter.remote.dubbo.publisher.PublisherGroupFactory;
import eventcenter.remote.dubbo.publisher.RemoteSubscriberFactory;
import eventcenter.remote.dubbo.subscriber.watchdog.SubscriberAware;
import eventcenter.remote.dubbo.subscriber.watchdog.SubscriberWatchDog;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.saf.EventForward;
import eventcenter.remote.saf.StoreAndForwardPolicy;
import eventcenter.remote.utils.ExpiryMap;
import eventcenter.remote.utils.StringHelper;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class SubcriberHolder {
    static final String LOCAL_IP1 = "127.0.0.1";
    static final String LOCAL_IP2 = "localhost";
    EventForward eventForward;
    StoreAndForwardPolicy storeAndForwardPolicy;
    Map<String, String> subscribEvents = new ConcurrentHashMap<String, String>();
    Map<String, RemoteSubscriberFactory> remoteSubscriberFactories = new ConcurrentHashMap<String, RemoteSubscriberFactory>();
    Map<String, EventSubscriber> eventSubscribers = new ConcurrentHashMap<String, EventSubscriber>();
    Map<String, PublisherGroupFactory> publisherGroupFactories = new ConcurrentHashMap<String, PublisherGroupFactory>();
    Map<String, Date> monitorMap = new ConcurrentHashMap<String, Date>();
    ExpiryMap<String, URL> garbagePool;
    Map<String, PublisherGroup> publisherGroups = new ConcurrentHashMap<String, PublisherGroup>();
    private boolean copySendUnderSameVersion = false;
    private int expiryOffline = 86400;
    private Object locker = new Object();
    private String localSubscriberId;
    private String localAddress;
    private boolean devMode = false;
    private SubscriberWatchDog subscriberWatchDog;
    private Long subscriberWatchDogExpiry;
    private Long subscriberWatchInterval;
    private String dubboGroup;
    private RegistryConfig registryConfig;
    private final Logger logger = Logger.getLogger(this.getClass());

    SubcriberHolder() {
    }

    public void shutdown() {
        if (this.needUseGarbagePool() && this.garbagePool != null) {
            this.garbagePool.shutdown();
        }
        if (this.subscriberWatchDog != null) {
            this.subscriberWatchDog.shutdown();
        }
    }

    public Map<String, PublisherGroup> getPublisherGroups() {
        return this.publisherGroups;
    }

    public RegistryConfig getRegistryConfig() {
        return this.registryConfig;
    }

    public void setRegistryConfig(RegistryConfig registryConfig) {
        this.registryConfig = registryConfig;
    }

    public String getDubboGroup() {
        return this.dubboGroup;
    }

    public void setDubboGroup(String dubboGroup) {
        this.dubboGroup = dubboGroup;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public String getLocalSubscriberId() {
        return this.localSubscriberId;
    }

    public void setLocalSubscriberId(String localSubscriberId) {
        this.localSubscriberId = localSubscriberId;
    }

    public void setExpiryOffline(int expiryOffline) {
        this.expiryOffline = expiryOffline;
    }

    public int getExpiryOffline() {
        return this.expiryOffline;
    }

    public void setEventForward(EventForward eventForward) {
        this.eventForward = eventForward;
    }

    public void setStoreAndForwardPolicy(StoreAndForwardPolicy storeAndForwardPolicy) {
        this.storeAndForwardPolicy = storeAndForwardPolicy;
    }

    public Map<String, String> getSubscribEvents() {
        return this.subscribEvents;
    }

    public Map<String, RemoteSubscriberFactory> getRemoteSubscriberFactories() {
        return this.remoteSubscriberFactories;
    }

    public Map<String, EventSubscriber> getEventSubscribers() {
        return this.eventSubscribers;
    }

    public Map<String, PublisherGroupFactory> getPublisherGroupFactories() {
        return this.publisherGroupFactories;
    }

    public Map<String, Date> getMonitorMap() {
        return this.monitorMap;
    }

    public boolean isCopySendUnderSameVersion() {
        return this.copySendUnderSameVersion;
    }

    public void setCopySendUnderSameVersion(boolean copySendUnderSameVersion) {
        this.copySendUnderSameVersion = copySendUnderSameVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExpiryMap<String, URL> getGarbagePool() {
        if (null != this.garbagePool) {
            return this.garbagePool;
        }
        Object object = this.locker;
        synchronized (object) {
            if (null != this.garbagePool) {
                return this.garbagePool;
            }
            this.garbagePool = this.createGarbagePool();
            this.garbagePool.startup();
            this.garbagePool.setExpiriedCallback((ExpiryMap.ExpiriedCallback)new ExpiryMap.ExpiriedCallback<String, URL>(){

                public void onExpiried(String key, URL value) {
                    SubcriberHolder.this.removeSubscriber(key, value);
                }
            });
            return this.garbagePool;
        }
    }

    ExpiryMap<String, URL> createGarbagePool() {
        return new ExpiryMap();
    }

    boolean needUseGarbagePool() {
        return null != this.eventForward;
    }

    boolean canIgnoreInstanceSubscriber(String address) {
        return this.needUseGarbagePool() && this.getGarbagePool().containKey((Object)address);
    }

    EventSubscriber createEventSubscriber(String address, URL url, RegistryConfig registryConfig) {
        RemoteSubscriberFactory factory = this.getRemoteSubscriberFactories().get(address);
        if (null == factory) {
            factory = this.createRemoteSubscriberFactory(url, address, registryConfig);
            this.getRemoteSubscriberFactories().put(address, factory);
        }
        if (this.canIgnoreInstanceSubscriber(address)) {
            return null;
        }
        return factory.createEventSubscriber();
    }

    void loadEventSubscriber(URL url) {
        String address = this.createAddress(url);
        if (StringHelper.equals((String)address, (String)this.localAddress)) {
            return;
        }
        if (!this.filterWithDevMode(url)) {
            return;
        }
        EventSubscriber subscriber = this.createEventSubscriber(address, url, this.registryConfig);
        if (null == subscriber) {
            return;
        }
        SubscriberInitStatus subscriberInitStatus = this.initEventSubscirber(this.dubboGroup, address, url, subscriber);
        if (SubscriberInitStatus.SUCCESS != subscriberInitStatus) {
            if (SubscriberInitStatus.NO_NEED == subscriberInitStatus && this.getRemoteSubscriberFactories().containsKey(address)) {
                this.getRemoteSubscriberFactories().get(address).destroy();
                this.getRemoteSubscriberFactories().remove(address);
            }
            return;
        }
        this.loadAndCreatePublisherGroup(url, address, this.registryConfig);
    }

    protected RemoteSubscriberFactory createRemoteSubscriberFactory(URL url, String address, RegistryConfig registryConfig) {
        RemoteSubscriberFactory factory = RemoteSubscriberFactory.buildWith(url, registryConfig);
        if (this.devMode || this.isCopySendUnderSameVersion()) {
            if (this.isCopySendUnderSameVersion()) {
                factory.getReferenceConfig().setUrl(this.buildDubboUrl(address));
            } else {
                factory.getReferenceConfig().setUrl(this.buildDubboUrl(url.getHost() + ":" + url.getPort()));
            }
        }
        return factory;
    }

    String buildDubboUrl(String address) {
        return "dubbo://" + address;
    }

    protected SubscriberInitStatus initEventSubscirber(String dubboGroup, String address, URL url, EventSubscriber subscriber) {
        try {
            if (null != this.localSubscriberId && this.localSubscriberId.equals(subscriber.getId())) {
                this.localAddress = address;
                return SubscriberInitStatus.NO_NEED;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.eventSubscribers.put(address, subscriber);
            SubscriberGroup group = subscriber.getSubscriberGroup(dubboGroup);
            if (null == group) {
                this.logger.warn((Object)new StringBuilder(url.toString()).append(" can't find group events!"));
                return SubscriberInitStatus.NO_NEED;
            }
            String remoteEvents = group.getRemoteEvents();
            if (StringUtils.isEmpty((String)remoteEvents)) {
                this.logger.warn((Object)new StringBuilder(url.toFullString()).append(" remote events is empty, ignore subscriber"));
                return SubscriberInitStatus.NO_NEED;
            }
            this.subscribEvents.put(address, remoteEvents);
            this.removeFromGarbagePool(address);
            return SubscriberInitStatus.SUCCESS;
        }
        catch (Exception e) {
            SubscriberWatchDog subscriberWatchDog;
            this.logger.error((Object)("load subscriber group failure:" + e.getMessage()), (Throwable)e);
            if (!this.subscribEvents.containsKey(address) && !(subscriberWatchDog = this.getSubscriberWatchDog()).containsSubscriber(subscriber)) {
                subscriberWatchDog.addSubscriber(subscriber, url);
            }
            return SubscriberInitStatus.FAILURE;
        }
    }

    protected PublisherGroup loadAndCreatePublisherGroup(URL url, String address, RegistryConfig registryConfig) {
        PublisherGroup publisherGroup = this.loadPublisherGroup(url, registryConfig);
        if (this.needUseGarbagePool() && publisherGroup != null) {
            try {
                this.addMonitor(address, publisherGroup);
            }
            catch (IOException e) {
                this.logger.error((Object)("add event forward monitor failure:" + e.getMessage()), (Throwable)e);
            }
        }
        if (null != publisherGroup) {
            this.publisherGroups.put(address, publisherGroup);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)new StringBuilder("load url:").append(url).append(" success. remote events:").append(publisherGroup.getRemoteEvents()));
            }
        }
        return publisherGroup;
    }

    PublisherGroup loadPublisherGroup(URL url, RegistryConfig registryConfig) {
        String address = this.createAddress(url);
        PublisherGroupFactory factory = this.getPublisherGroupFactories().get(address);
        if (null == factory) {
            factory = this.createPublisherGroupFactory(url, address, registryConfig);
            this.getPublisherGroupFactories().put(address, factory);
        } else if (this.needUpdatePublisherGroupFactory(factory, address)) {
            this.updatePublisherGroupFactory(factory, address);
        }
        try {
            PublisherGroup group = factory.createPublisherGroup();
            group.setRemoteUrl(url.getAddress());
            group.setGroupName(this.buildGroupName(url));
            return group;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    String buildGroupName(URL url) {
        return url.getParameter("group") + "_" + url.getParameter("application");
    }

    void destroySubscribers(List<URL> urls) {
        for (URL url : urls) {
            this.destroySubscriber(url);
        }
    }

    void destroySubscriber(URL url) {
        String address = this.createAddress(url);
        if (this.needUseGarbagePool()) {
            if (!this.getGarbagePool().containKey((Object)address)) {
                if (!this.filterWithDevMode(url)) {
                    return;
                }
                if (null != this.localAddress && this.localAddress.equals(address)) {
                    return;
                }
                this.getGarbagePool().put((Object)address, (long)(this.expiryOffline * 1000), (Object)url);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("\u53d1\u73b0\u6d88\u8d39\u70b9\u79bb\u7ebf\u4e86\uff0curl:" + new StringBuilder(url.getHost()).append(":").append(url.getPort()).append(",version:").append(url.getParameter("version,\u79bb\u7ebf\u961f\u5217\u5931\u6548\u65f6\u95f4")).append(this.expiryOffline).append(" s.")));
                }
            }
            return;
        }
        this.removeSubscriber(address, url);
    }

    boolean filterWithDevMode(URL url) {
        if (!this.devMode) {
            return true;
        }
        String remoteAddress = url.getHost() + ":" + url.getPort();
        if (remoteAddress.contains(LOCAL_IP1) || remoteAddress.contains(LOCAL_IP2)) {
            return true;
        }
        return remoteAddress.contains(NetUtils.getLocalHost());
    }

    public Long getSubscriberWatchDogExpiry() {
        return this.subscriberWatchDogExpiry;
    }

    public void setSubscriberWatchDogExpiry(Long subscriberWatchDogExpiry) {
        this.subscriberWatchDogExpiry = subscriberWatchDogExpiry;
    }

    public Long getSubscriberWatchInterval() {
        return this.subscriberWatchInterval;
    }

    public void setSubscriberWatchInterval(Long subscriberWatchInterval) {
        this.subscriberWatchInterval = subscriberWatchInterval;
    }

    void updatePublisherGroupFactory(PublisherGroupFactory factory, String address) {
        factory.setRemoteEvents(this.getSubscribEvents().get(address));
    }

    boolean needUpdatePublisherGroupFactory(PublisherGroupFactory factory, String address) {
        return !StringUtils.isEquals((String)factory.getRemoteEvents(), (String)this.getSubscribEvents().get(address));
    }

    String createAddress(URL url) {
        if (this.copySendUnderSameVersion) {
            return url.getHost() + ":" + url.getPort();
        }
        return url.getParameter("version");
    }

    protected PublisherGroupFactory createPublisherGroupFactory(URL url, String address, RegistryConfig registryConfig) {
        if (this.copySendUnderSameVersion) {
            return PublisherGroupFactory.buildWith(url, this.subscribEvents.get(address));
        }
        return PublisherGroupFactory.buildWith(url, this.subscribEvents.get(address), registryConfig);
    }

    void addMonitor(String address, PublisherGroup publisherGroup) throws IOException {
        if (this.monitorMap.containsKey(address)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)new StringBuilder(address).append(" had been add monitor, can't add again!"));
            }
            return;
        }
        this.eventForward.addMonitor(publisherGroup, this.storeAndForwardPolicy.createEventQueue(address));
        this.monitorMap.put(address, new Date());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)new StringBuilder("add monitor for event forward:").append(address));
        }
    }

    void removeSubscriber(String address, URL url) {
        PublisherGroup group = this.publisherGroups.get(address);
        if (this.needUseGarbagePool() && group != null) {
            boolean health = false;
            try {
                health = group.getEventTransmission().checkHealth();
            }
            catch (Exception e) {
                this.logger.error((Object)new StringBuilder("check health failure before remove subscriber, reason:").append(e.getMessage()).append(", url:").append(url));
            }
            if (health) {
                this.logger.info((Object)new StringBuilder("recovery connection, subscriber won't be remove:").append(url));
                return;
            }
            try {
                this.monitorMap.remove(address);
                this.eventForward.removeMonitor(group);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)new StringBuilder("remove monitor for event forward:").append(address));
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.removeEventSubscriber(address);
        this.removePublisherGroup(address, url);
    }

    void removeEventSubscriber(String address) {
        if (this.eventSubscribers.containsKey(address)) {
            EventSubscriber eventSubscriber = this.eventSubscribers.remove(address);
            if (null != this.subscriberWatchDog && this.getSubscriberWatchDog().containsSubscriber(eventSubscriber)) {
                this.getSubscriberWatchDog().removeSubscriber(eventSubscriber);
            }
        }
        if (this.subscribEvents.containsKey(address)) {
            this.subscribEvents.remove(address);
        }
        if (this.remoteSubscriberFactories.containsKey(address)) {
            try {
                this.remoteSubscriberFactories.get(address).destroy();
                this.remoteSubscriberFactories.remove(address);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    void removePublisherGroup(String address, URL url) {
        if (this.publisherGroups.containsKey(address)) {
            this.publisherGroups.remove(address);
        }
        if (this.publisherGroupFactories.containsKey(address)) {
            try {
                this.publisherGroupFactories.get(address).destroy();
                this.publisherGroupFactories.remove(address);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)new StringBuilder("destroy url:").append(url).append(" success"));
            }
        }
    }

    void removeFromGarbagePool(String address) {
        if (this.needUseGarbagePool() && this.getGarbagePool().containKey((Object)address)) {
            this.getGarbagePool().remove((Object)address);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)new StringBuilder("remove garbagePool:").append(address));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscriberWatchDog getSubscriberWatchDog() {
        if (null != this.subscriberWatchDog) {
            return this.initSubscriberWatchDog();
        }
        Object object = this.locker;
        synchronized (object) {
            if (this.subscriberWatchDog != null) {
                return this.subscriberWatchDog;
            }
            this.subscriberWatchDog = new SubscriberWatchDog(new InnerSubscriberAware(), this.dubboGroup);
            if (null != this.subscriberWatchDogExpiry) {
                this.subscriberWatchDog.setExpiry(this.subscriberWatchDogExpiry);
            }
            if (null != this.subscriberWatchInterval) {
                this.subscriberWatchDog.setWatchInterval(this.subscriberWatchInterval);
            }
            return this.initSubscriberWatchDog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscriberWatchDog initSubscriberWatchDog() {
        if (this.subscriberWatchDog.isOpen()) {
            return this.subscriberWatchDog;
        }
        Object object = this.locker;
        synchronized (object) {
            if (this.subscriberWatchDog.isOpen()) {
                return this.subscriberWatchDog;
            }
            this.subscriberWatchDog.start();
        }
        return this.subscriberWatchDog;
    }

    static enum SubscriberInitStatus {
        SUCCESS,
        FAILURE,
        NO_NEED;

    }

    class InnerSubscriberAware
    implements SubscriberAware {
        InnerSubscriberAware() {
        }

        @Override
        public void checkRemoteEventsSuccess(EventSubscriber eventSubscriber, URL url, SubscriberGroup subscriberGroup) {
            String address = this.findAddress(eventSubscriber);
            if (SubcriberHolder.this.subscribEvents.containsKey(address)) {
                return;
            }
            String remoteEvents = subscriberGroup.getRemoteEvents();
            if (StringUtils.isEmpty((String)remoteEvents)) {
                return;
            }
            SubcriberHolder.this.subscribEvents.put(address, remoteEvents);
            SubcriberHolder.this.loadAndCreatePublisherGroup(url, address, SubcriberHolder.this.registryConfig);
        }

        @Override
        public void expiried(EventSubscriber eventSubscriber, URL url) {
            String address = this.findAddress(eventSubscriber);
            if (SubcriberHolder.this.subscribEvents.containsKey(address)) {
                return;
            }
            SubcriberHolder.this.removeEventSubscriber(address);
        }

        String findAddress(EventSubscriber eventSubscriber) {
            Set<Map.Entry<String, EventSubscriber>> entries = SubcriberHolder.this.eventSubscribers.entrySet();
            for (Map.Entry<String, EventSubscriber> entry : entries) {
                if (entry.getValue() == null || entry.getValue() != eventSubscriber) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

