/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.remote.dubbo.subscriber.watchdog;

import com.alibaba.dubbo.common.URL;
import eventcenter.remote.EventSubscriber;
import eventcenter.remote.SubscriberGroup;
import eventcenter.remote.dubbo.subscriber.watchdog.SubscriberAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class SubscriberWatchDog
extends Thread {
    private long expiry = 3600000L;
    private long watchInterval = 10000L;
    private final SubscriberAware subscriberAware;
    private final String group;
    private Object lock = new Object();
    private volatile boolean open = false;
    private final Logger logger = Logger.getLogger(this.getClass());
    private Map<EventSubscriber, SubscriberInfo> subscribers = Collections.synchronizedMap(new HashMap());

    public SubscriberWatchDog(SubscriberAware subscriberAware, String group) {
        super("ec-subscriber-watch-dog");
        this.subscriberAware = subscriberAware;
        this.group = group;
    }

    public boolean isOpen() {
        return this.open;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public long getWatchInterval() {
        return this.watchInterval;
    }

    public void setWatchInterval(long watchInterval) {
        this.watchInterval = watchInterval;
    }

    public boolean containsSubscriber(EventSubscriber eventSubscriber) {
        return this.subscribers.containsKey(eventSubscriber);
    }

    public boolean removeSubscriber(EventSubscriber eventSubscriber) {
        return this.subscribers.remove(eventSubscriber) != null;
    }

    public int sizeOfSubscribers() {
        return this.subscribers.size();
    }

    public void addSubscriber(EventSubscriber eventSubscriber, URL url) {
        this.subscribers.put(eventSubscriber, new SubscriberInfo(eventSubscriber, url));
    }

    @Override
    public void start() {
        if (this.open) {
            return;
        }
        this.open = true;
        super.start();
    }

    @Override
    public void run() {
        try {
            this.logger.info((Object)"open subscriber watch dog success");
            while (this.open) {
                if (this.sizeOfSubscribers() == 0) {
                    this.sleep();
                    continue;
                }
                this.iterateAndCheck();
                this.sleep();
            }
            this.logger.info((Object)"shutdown subscriber watch dog success");
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    void iterateAndCheck() {
        Collection<SubscriberInfo> infos;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("start to check, size of subscribers:" + this.subscribers.size()));
        }
        int listSize = (infos = this.subscribers.values()).size() > 16 ? infos.size() : infos.size();
        ArrayList<SubscriberInfo> deleteInfos = new ArrayList<SubscriberInfo>(listSize);
        for (SubscriberInfo info : infos) {
            SubscriberGroup subscriberGroup = this.checkSubscriberInfo(info);
            if (null != subscriberGroup) {
                try {
                    this.subscriberAware.checkRemoteEventsSuccess(info.getEventSubscriber(), info.getUrl(), subscriberGroup);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("check subscriber success[" + subscriberGroup + "]"));
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                deleteInfos.add(info);
                continue;
            }
            if (!info.isExpiry()) continue;
            deleteInfos.add(info);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)"check subscriber expiry, it would remove it!");
        }
        if (deleteInfos.size() == 0) {
            return;
        }
        for (SubscriberInfo deletedInfo : deleteInfos) {
            this.subscribers.remove(deletedInfo.getEventSubscriber());
            this.subscriberAware.expiried(deletedInfo.getEventSubscriber(), deletedInfo.getUrl());
        }
    }

    SubscriberGroup checkSubscriberInfo(SubscriberInfo info) {
        try {
            return info.getSubscriberGroup(this.group);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sleep() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(this.watchInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void shutdown() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.subscribers.clear();
        this.wakeUp();
    }

    static /* synthetic */ long access$000(SubscriberWatchDog x0) {
        return x0.expiry;
    }

    class SubscriberInfo {
        final EventSubscriber eventSubscriber;
        final URL url;
        final Date created = new Date();
        final Date expiryDate = DateUtils.addMilliseconds((Date)this.created, (int)((int)SubscriberWatchDog.access$000(SubscriberWatchDog.this)));

        SubscriberInfo(EventSubscriber eventSubscriber, URL url) {
            this.eventSubscriber = eventSubscriber;
            this.url = url;
        }

        boolean isExpiry() {
            return this.expiryDate.before(this.now());
        }

        SubscriberGroup getSubscriberGroup(String group) {
            return this.eventSubscriber.getSubscriberGroup(group);
        }

        public EventSubscriber getEventSubscriber() {
            return this.eventSubscriber;
        }

        public URL getUrl() {
            return this.url;
        }

        public Date getCreated() {
            return this.created;
        }

        Date now() {
            return new Date();
        }
    }
}

