/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.spring.jdbc.sqldialect;

import io.eventuate.common.jdbc.sqldialect.DefaultEventuateSqlDialect;
import io.eventuate.common.jdbc.sqldialect.EventuateSqlDialect;
import io.eventuate.common.jdbc.sqldialect.MsSqlDialect;
import io.eventuate.common.jdbc.sqldialect.MySqlDialect;
import io.eventuate.common.jdbc.sqldialect.PostgresDialect;
import io.eventuate.common.jdbc.sqldialect.SqlDialectSelector;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SqlDialectConfiguration {
    @Bean
    public MySqlDialect mySqlDialect() {
        return new MySqlDialect();
    }

    @Bean
    public PostgresDialect postgreSQLDialect() {
        return new PostgresDialect();
    }

    @Bean
    public MsSqlDialect msSqlDialect() {
        return new MsSqlDialect();
    }

    @Bean
    public DefaultEventuateSqlDialect defaultSqlDialect(@Value(value="${eventuate.current.time.in.milliseconds.sql:#{null}}") String customCurrentTimeInMillisecondsExpression) {
        return new DefaultEventuateSqlDialect(customCurrentTimeInMillisecondsExpression);
    }

    @Bean
    public SqlDialectSelector sqlDialectSelector(Collection<EventuateSqlDialect> dialects) {
        return new SqlDialectSelector(dialects);
    }
}

