/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.id;

import io.eventuate.common.id.IdGenerator;
import io.eventuate.common.id.Int128;
import java.util.Optional;

public class DatabaseIdGenerator
implements IdGenerator {
    public static final long SERVICE_ID_MAX_VALUE = 0xFFFFFFFFFFFFL;
    public static final long COUNTER_MAX_VALUE = 65535L;
    private final long serviceId;

    @Override
    public boolean databaseIdRequired() {
        return true;
    }

    public DatabaseIdGenerator(long serviceId) {
        this.serviceId = serviceId;
        if (serviceId < 0L || serviceId > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("service id should be between 0 and %s", 0xFFFFFFFFFFFFL));
        }
    }

    @Override
    public Int128 genId(Long databaseId) {
        if (databaseId == null) {
            throw new IllegalArgumentException("database id is required");
        }
        return new Int128(databaseId, this.serviceId);
    }

    @Override
    public Optional<Int128> incrementIdIfPossible(Int128 anchorId) {
        long counter = anchorId.getLo() >>> 48;
        if (counter == 65535L) {
            return Optional.empty();
        }
        ++counter;
        long lo = anchorId.getLo() & 0xFFFFFFFFFFFFL | (counter <<= 48);
        return Optional.of(new Int128(anchorId.getHi(), lo));
    }
}

