/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.id;

import io.eventuate.common.id.IdGenerator;
import io.eventuate.common.id.Int128;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationIdGenerator
implements IdGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long MAX_COUNTER = 65536L;
    private Long macAddress;
    private long currentPeriod = this.timeNow();
    private long counter = 0L;

    public ApplicationIdGenerator() {
        try {
            this.macAddress = this.getMacAddress();
            this.logger.debug("Mac address {}", (Object)this.macAddress);
            if (this.macAddress == null) {
                throw new RuntimeException("Cannot find mac address");
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean databaseIdRequired() {
        return false;
    }

    private Long getMacAddress() throws SocketException {
        String ma = System.getenv("EVENTUATE_MAC_ADDRESS");
        if (ma != null) {
            return Long.parseLong(ma);
        }
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            if (iface.getHardwareAddress() == null) continue;
            return this.toLong(iface.getHardwareAddress());
        }
        return null;
    }

    private Long toLong(byte[] bytes) {
        long result = 0L;
        for (byte b : bytes) {
            result = (result << 8) + (long)(b & 0xFF);
        }
        return result;
    }

    private long timeNow() {
        return System.currentTimeMillis();
    }

    private Int128 makeId() {
        return new Int128(this.currentPeriod, (this.macAddress << 16) + this.counter);
    }

    public Int128 genIdInternal() {
        long now = this.timeNow();
        if (this.currentPeriod != now || this.counter == 65536L) {
            long oldPeriod = this.currentPeriod;
            while ((this.currentPeriod = this.timeNow()) <= oldPeriod) {
            }
            this.counter = 0L;
        }
        Int128 id = this.makeId();
        ++this.counter;
        return id;
    }

    @Override
    public synchronized Int128 genId(Long databaseId, Integer partitionOffset) {
        return this.genIdInternal();
    }

    @Override
    public Optional<Int128> incrementIdIfPossible(Int128 anchorId) {
        return Optional.of(this.genId(null, null));
    }
}

