/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.jdbc.sqldialect;

import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateSchema;
import io.eventuate.common.jdbc.sqldialect.AbstractEventuateSqlDialect;
import io.eventuate.common.jdbc.sqldialect.ColumnCacheKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.postgresql.util.PGobject;

public class PostgresDialect
extends AbstractEventuateSqlDialect {
    private ConcurrentMap<ColumnCacheKey, String> columnTypeCache = new ConcurrentHashMap<ColumnCacheKey, String>();

    public PostgresDialect() {
        super(Collections.singleton("org.postgresql.Driver"), Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("postgres", "postgresql", "pgsql", "pg"))), "(ROUND(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000))");
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String castToJson(String sqlPart, EventuateSchema eventuateSchema, String unqualifiedTable, String column, BiFunction<String, List<Object>, List<Map<String, Object>>> selectCallback) {
        String columnType = this.getColumnType(eventuateSchema, unqualifiedTable, column, selectCallback);
        return String.format("%s::%s", sqlPart, columnType);
    }

    @Override
    public String jsonColumnToString(Object object, EventuateSchema eventuateSchema, String unqualifiedTable, String column, EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof PGobject) {
            PGobject pGobject = (PGobject)object;
            if ("json".equals(pGobject.getType())) {
                return pGobject.getValue();
            }
            throw new IllegalArgumentException(String.format("Unsupported postgres type %s of column %s", pGobject.getType(), column));
        }
        throw new IllegalArgumentException(String.format("Unsupported java type %s for column %s", object.getClass(), column));
    }

    public String getColumnType(EventuateSchema eventuateSchema, String unqualifiedTable, String column, BiFunction<String, List<Object>, List<Map<String, Object>>> selectCallback) {
        return this.columnTypeCache.computeIfAbsent(new ColumnCacheKey(eventuateSchema.getEventuateDatabaseSchema(), unqualifiedTable, column), columnCacheKey -> {
            String sql = "select data_type from information_schema.columns where table_schema = ? and table_name = ? and column_name = ?";
            return (String)((Map)((List)selectCallback.apply("select data_type from information_schema.columns where table_schema = ? and table_name = ? and column_name = ?", Arrays.asList(eventuateSchema.getEventuateDatabaseSchema(), unqualifiedTable, column))).get(0)).get("data_type");
        });
    }

    @Override
    public String addReturningOfGeneratedIdToSql(String sql, String idColumn) {
        return String.format("%s RETURNING %s", sql, idColumn);
    }
}

