/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.jdbc;

import io.eventuate.common.id.IdGenerator;
import io.eventuate.common.jdbc.EventuateJdbcOperationsUtils;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateSchema;
import io.eventuate.common.jdbc.OutboxPartitionValues;
import io.eventuate.common.jdbc.OutboxPartitioningSpec;
import io.eventuate.common.jdbc.sqldialect.EventuateSqlDialect;
import io.eventuate.common.json.mapper.JSonMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class EventuateCommonJdbcOperations {
    private EventuateJdbcOperationsUtils eventuateJdbcOperationsUtils;
    private EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor;
    private OutboxPartitioningSpec outboxPartitioningSpec;
    private EventuateSqlDialect eventuateSqlDialect;

    public EventuateCommonJdbcOperations(EventuateJdbcOperationsUtils eventuateJdbcOperationsUtils, EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor, EventuateSqlDialect eventuateSqlDialect, OutboxPartitioningSpec outboxPartitioningSpec) {
        this.eventuateJdbcOperationsUtils = eventuateJdbcOperationsUtils;
        this.eventuateSqlDialect = eventuateSqlDialect;
        this.eventuateJdbcStatementExecutor = eventuateJdbcStatementExecutor;
        this.outboxPartitioningSpec = outboxPartitioningSpec;
    }

    public EventuateSqlDialect getEventuateSqlDialect() {
        return this.eventuateSqlDialect;
    }

    public String insertIntoEventsTable(IdGenerator idGenerator, String entityId, String eventData, String eventType, String entityType, Optional<String> triggeringEvent, Optional<String> metadata, EventuateSchema eventuateSchema) {
        return this.insertIntoEventsTable(idGenerator, entityId, eventData, eventType, entityType, triggeringEvent, metadata, eventuateSchema, false);
    }

    public String insertPublishedEventIntoEventsTable(IdGenerator idGenerator, String entityId, String eventData, String eventType, String entityType, Optional<String> triggeringEvent, Optional<String> metadata, EventuateSchema eventuateSchema) {
        return this.insertIntoEventsTable(idGenerator, entityId, eventData, eventType, entityType, triggeringEvent, metadata, eventuateSchema, true);
    }

    private String insertIntoEventsTable(IdGenerator idGenerator, String entityId, String eventData, String eventType, String entityType, Optional<String> triggeringEvent, Optional<String> metadata, EventuateSchema eventuateSchema, boolean published) {
        if (idGenerator.databaseIdRequired()) {
            Long databaseId = this.eventuateJdbcStatementExecutor.insertAndReturnGeneratedId(this.eventuateJdbcOperationsUtils.insertIntoEventsTableDbIdSql(eventuateSchema), "id", eventType, eventData, entityType, entityId, triggeringEvent.orElse(null), metadata.orElse(null), this.eventuateJdbcOperationsUtils.booleanToInt(published));
            return idGenerator.genId(databaseId, null).asString();
        }
        String eventId = idGenerator.genId().asString();
        this.eventuateJdbcStatementExecutor.update(this.eventuateJdbcOperationsUtils.insertIntoEventsTableApplicationIdSql(eventuateSchema), eventId, eventType, eventData, entityType, entityId, triggeringEvent.orElse(null), metadata.orElse(null), this.eventuateJdbcOperationsUtils.booleanToInt(published));
        return eventId;
    }

    public String insertIntoMessageTable(IdGenerator idGenerator, String payload, String destination, Map<String, String> headers, EventuateSchema eventuateSchema) {
        return this.insertIntoMessageTable(idGenerator, payload, destination, headers, eventuateSchema, false);
    }

    public String insertPublishedMessageIntoMessageTable(IdGenerator idGenerator, String payload, String destination, Map<String, String> headers, EventuateSchema eventuateSchema) {
        return this.insertIntoMessageTable(idGenerator, payload, destination, headers, eventuateSchema, true);
    }

    private String insertIntoMessageTable(IdGenerator idGenerator, String payload, String destination, Map<String, String> headers, EventuateSchema eventuateSchema, boolean published) {
        String messageKey = headers.get("PARTITION_ID");
        OutboxPartitionValues outboxPartitionValues = this.outboxPartitioningSpec.outboxTableValues(destination, messageKey);
        if (idGenerator.databaseIdRequired()) {
            return this.insertIntoMessageTableDatabaseId(idGenerator, payload, destination, headers, published, eventuateSchema, outboxPartitionValues);
        }
        return this.insertIntoMessageTableApplicationId(idGenerator, payload, destination, headers, published, eventuateSchema, outboxPartitionValues);
    }

    private String insertIntoMessageTableApplicationId(IdGenerator idGenerator, String payload, String destination, Map<String, String> headers, boolean published, EventuateSchema eventuateSchema, OutboxPartitionValues outboxPartitionValues) {
        headers = new HashMap<String, String>(headers);
        String messageId = idGenerator.genId(null, outboxPartitionValues.outboxTableSuffix.suffix).asString();
        headers.put("ID", messageId);
        String serializedHeaders = JSonMapper.toJson(headers);
        this.eventuateJdbcStatementExecutor.update(this.eventuateJdbcOperationsUtils.insertIntoMessageTableApplicationIdSql(eventuateSchema, this::columnToJson, outboxPartitionValues.outboxTableSuffix.suffixAsString), messageId, destination, serializedHeaders, payload, this.eventuateJdbcOperationsUtils.booleanToInt(published), outboxPartitionValues.messagePartition);
        return messageId;
    }

    private String insertIntoMessageTableDatabaseId(IdGenerator idGenerator, String payload, String destination, Map<String, String> headers, boolean published, EventuateSchema eventuateSchema, OutboxPartitionValues outboxPartitionValues) {
        String serializedHeaders = JSonMapper.toJson(headers);
        long databaseId = this.eventuateJdbcStatementExecutor.insertAndReturnGeneratedId(this.eventuateJdbcOperationsUtils.insertIntoMessageTableDbIdSql(eventuateSchema, this::columnToJson, outboxPartitionValues.outboxTableSuffix.suffixAsString), "dbid", destination, serializedHeaders, payload, this.eventuateJdbcOperationsUtils.booleanToInt(published), outboxPartitionValues.messagePartition);
        return idGenerator.genId(Long.valueOf(databaseId), outboxPartitionValues.outboxTableSuffix.suffix).asString();
    }

    protected String columnToJson(EventuateSchema eventuateSchema, String column) {
        return this.getEventuateSqlDialect().castToJson("?", eventuateSchema, "message", column, (sql, args) -> this.eventuateJdbcStatementExecutor.queryForList((String)sql, args.toArray()));
    }
}

