/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.jdbc;

import io.eventuate.common.jdbc.OutboxPartitionValues;
import io.eventuate.common.jdbc.OutboxTableSuffix;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OutboxPartitioningSpec {
    private final Integer outboxTables;
    private final Integer outboxTablePartitions;
    public static final OutboxPartitioningSpec DEFAULT = new OutboxPartitioningSpec(null, null);

    public OutboxPartitioningSpec(Integer outboxTables, Integer outboxTablePartitions) {
        this.outboxTables = outboxTables;
        this.outboxTablePartitions = outboxTablePartitions;
    }

    public OutboxPartitionValues outboxTableValues(String destination, String messageKey) {
        Integer hash = Math.abs(Objects.hash(destination, messageKey));
        Integer outboxTableSuffix = this.nullOrOne(this.outboxTables) || messageKey == null ? null : Integer.valueOf(hash % this.outboxTables);
        Integer messagePartition = this.nullOrOne(this.outboxTablePartitions) || messageKey == null ? null : Integer.valueOf(hash % this.outboxTablePartitions);
        return new OutboxPartitionValues(outboxTableSuffix, messagePartition);
    }

    private boolean nullOrOne(Integer x) {
        return x == null || x == 1;
    }

    public List<OutboxTableSuffix> outboxTableSuffixes() {
        if (this.nullOrOne(this.outboxTables)) {
            return Collections.singletonList(new OutboxTableSuffix(null));
        }
        return IntStream.range(0, this.outboxTables).mapToObj(OutboxTableSuffix::new).collect(Collectors.toList());
    }

    public OutboxPartitioningSpec withOutboxTables(int outboxTables) {
        return new OutboxPartitioningSpec(outboxTables, this.outboxTablePartitions);
    }

    public OutboxPartitioningSpec withTablePartitions(int outboxTables) {
        return new OutboxPartitioningSpec(this.outboxTables, this.outboxTablePartitions);
    }
}

