/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.jdbc;

import io.eventuate.common.jdbc.EventuateDuplicateKeyException;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateRowMapper;
import io.eventuate.common.jdbc.EventuateSqlException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class EventuateCommonJdbcStatementExecutor
implements EventuateJdbcStatementExecutor {
    private static final Set<Integer> DUPLICATE_KEY_ERROR_CODES = new HashSet<Integer>(Arrays.asList(1062, 2601, 2627, 23505, 23001));
    private Supplier<Connection> connectionProvider;

    public EventuateCommonJdbcStatementExecutor(Supplier<Connection> connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long insertAndReturnGeneratedId(String sql, String idColumn, Object ... parameters) {
        Connection connection = this.connectionProvider.get();
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);){
            for (int i = 1; i <= parameters.length; ++i) {
                preparedStatement.setObject(i, parameters[i - 1]);
            }
            preparedStatement.executeUpdate();
            try (ResultSet generatedKeys = preparedStatement.getGeneratedKeys();){
                if (!generatedKeys.next()) throw new EventuateSqlException("Id was not generated");
                if (generatedKeys.getMetaData().getColumnCount() == 1) {
                    long l = generatedKeys.getLong(1);
                    return l;
                }
                long l = generatedKeys.getLong(idColumn);
                return l;
            }
        }
        catch (SQLException e) {
            this.handleSqlUpdateException(e);
            return -1L;
        }
    }

    @Override
    public int update(String sql, Object ... parameters) {
        int n;
        block9: {
            Connection connection = this.connectionProvider.get();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            try {
                for (int i = 1; i <= parameters.length; ++i) {
                    preparedStatement.setObject(i, parameters[i - 1]);
                }
                n = preparedStatement.executeUpdate();
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.handleSqlUpdateException(e);
                    return 0;
                }
            }
            preparedStatement.close();
        }
        return n;
    }

    @Override
    public <T> List<T> query(String sql, EventuateRowMapper<T> eventuateRowMapper, Object ... parameters) {
        ArrayList<T> arrayList;
        block10: {
            Connection connection = this.connectionProvider.get();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            try {
                for (int i = 1; i <= parameters.length; ++i) {
                    preparedStatement.setObject(i, parameters[i - 1]);
                }
                ResultSet rs = preparedStatement.executeQuery();
                ArrayList<T> result = new ArrayList<T>();
                int rowNum = 0;
                while (rs.next()) {
                    result.add(eventuateRowMapper.mapRow(rs, rowNum++));
                }
                arrayList = result;
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new EventuateSqlException(e);
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... parameters) {
        ArrayList<Map<String, Object>> arrayList;
        block11: {
            Connection connection = this.connectionProvider.get();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            try {
                for (int i = 1; i <= parameters.length; ++i) {
                    preparedStatement.setObject(i, parameters[i - 1]);
                }
                ResultSet rs = preparedStatement.executeQuery();
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        row.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                    }
                    result.add(row);
                }
                arrayList = result;
                if (preparedStatement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new EventuateSqlException(e);
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }

    private void handleSqlUpdateException(SQLException e) {
        block5: {
            block4: {
                Optional<Object> additionalErrorCode = Optional.empty();
                try {
                    additionalErrorCode = Optional.of(Integer.parseInt(e.getSQLState()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (DUPLICATE_KEY_ERROR_CODES.contains(e.getErrorCode())) break block4;
                if (!additionalErrorCode.map(DUPLICATE_KEY_ERROR_CODES::contains).orElse(false).booleanValue()) break block5;
            }
            throw new EventuateDuplicateKeyException(e);
        }
        throw new EventuateSqlException(e);
    }
}

