/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.spring.jdbc;

import io.eventuate.common.jdbc.EventuateDuplicateKeyException;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateRowMapper;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class EventuateSpringJdbcStatementExecutor
implements EventuateJdbcStatementExecutor {
    private JdbcTemplate jdbcTemplate;

    public EventuateSpringJdbcStatementExecutor(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public long insertAndReturnGeneratedId(String sql, String idColumn, Object ... params) {
        try {
            GeneratedKeyHolder holder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(connection -> {
                PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
                for (int i = 1; i <= params.length; ++i) {
                    preparedStatement.setObject(i, params[i - 1]);
                }
                return preparedStatement;
            }, (KeyHolder)holder);
            if (holder.getKeys().size() > 1) {
                return (Long)holder.getKeys().get(idColumn);
            }
            return holder.getKey().longValue();
        }
        catch (DuplicateKeyException e) {
            throw new EventuateDuplicateKeyException((Throwable)e);
        }
    }

    public int update(String sql, Object ... params) {
        try {
            return this.jdbcTemplate.update(sql, params);
        }
        catch (DuplicateKeyException e) {
            throw new EventuateDuplicateKeyException((Throwable)e);
        }
    }

    public <T> List<T> query(String sql, EventuateRowMapper<T> eventuateRowMapper, Object ... params) {
        return this.jdbcTemplate.query(sql, (arg_0, arg_1) -> eventuateRowMapper.mapRow(arg_0, arg_1), params);
    }

    public List<Map<String, Object>> queryForList(String sql, Object ... parameters) {
        return this.jdbcTemplate.queryForList(sql, parameters);
    }
}

