/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.partitionmanagement;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Assignment {
    private Set<String> channels;
    private Map<String, Set<Integer>> partitionAssignmentsByChannel;

    public Assignment() {
    }

    public Assignment(Assignment copy) {
        this.channels = new HashSet<String>(copy.getChannels());
        this.partitionAssignmentsByChannel = new HashMap<String, Set<Integer>>();
        copy.getPartitionAssignmentsByChannel().forEach((channel, partitions) -> this.partitionAssignmentsByChannel.put((String)channel, new HashSet(partitions)));
    }

    public Assignment(Set<String> channels, Map<String, Set<Integer>> partitionAssignmentsByChannel) {
        this.channels = channels;
        this.partitionAssignmentsByChannel = partitionAssignmentsByChannel;
    }

    public Set<String> getChannels() {
        return this.channels;
    }

    public void setChannels(Set<String> channels) {
        this.channels = channels;
    }

    public Map<String, Set<Integer>> getPartitionAssignmentsByChannel() {
        return this.partitionAssignmentsByChannel;
    }

    public void setPartitionAssignmentsByChannel(Map<String, Set<Integer>> partitionAssignmentsByChannel) {
        this.partitionAssignmentsByChannel = partitionAssignmentsByChannel;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignment that = (Assignment)o;
        return Objects.equals(this.channels, that.channels) && Objects.equals(this.partitionAssignmentsByChannel, that.partitionAssignmentsByChannel);
    }

    public int hashCode() {
        return Objects.hash(this.channels, this.partitionAssignmentsByChannel);
    }
}

