/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.commonimpl.common.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.eventuate.common.json.mapper.JSonMapper;
import io.eventuate.javaclient.commonimpl.common.EventIdTypeAndData;
import io.eventuate.javaclient.commonimpl.common.schema.AggregateSchemaVersion;
import io.eventuate.javaclient.commonimpl.common.schema.EventUpcaster;
import io.eventuate.javaclient.commonimpl.common.schema.NewEventNameAndUpcasters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class AggregateSchema {
    private final String aggregateType;
    private final List<AggregateSchemaVersion> versions;

    public AggregateSchema(String aggregateType, List<AggregateSchemaVersion> versions) {
        this.aggregateType = aggregateType;
        this.versions = versions;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public String currentVersion() {
        return this.versions.get(this.versions.size() - 1).getVersion();
    }

    public List<EventIdTypeAndData> upcastEvents(List<EventIdTypeAndData> events) {
        String currentVersion = this.currentVersion();
        return events.stream().map(event -> this.maybeUpcast(currentVersion, (EventIdTypeAndData)event)).collect(Collectors.toList());
    }

    private EventIdTypeAndData maybeUpcast(String latestVersion, EventIdTypeAndData event) {
        String actualVersion = this.eventVersion(event);
        return this.needsUpcast(latestVersion, actualVersion) ? this.upcast(event, latestVersion, actualVersion) : event;
    }

    private EventIdTypeAndData upcast(EventIdTypeAndData event, String toVersion, String fromVersion) {
        String newJson;
        JsonNode json;
        String originalEventType = event.getEventType();
        NewEventNameAndUpcasters newEventTypeAndUpcasters = this.findUpcasters(originalEventType, fromVersion, toVersion);
        if (newEventTypeAndUpcasters.isEmpty()) {
            return event;
        }
        try {
            json = JSonMapper.objectMapper.readTree(event.getEventData());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        for (EventUpcaster upcaster : newEventTypeAndUpcasters.getUpcasters()) {
            json = upcaster.upcast(json);
        }
        try {
            newJson = JSonMapper.objectMapper.writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new EventIdTypeAndData(event.getId(), newEventTypeAndUpcasters.getEventType().orElse(originalEventType), newJson, this.withNewVersion(event.getMetadata(), this.currentVersion()));
    }

    private NewEventNameAndUpcasters findUpcasters(String eventType, String fromVersion, String toVersion) {
        int versionIndex = 0;
        String originalEventType = eventType;
        while (fromVersion != null && !this.versions.get(versionIndex++).getVersion().equals(fromVersion)) {
        }
        ArrayList<EventUpcaster> upcasters = new ArrayList<EventUpcaster>();
        while (versionIndex < this.versions.size()) {
            AggregateSchemaVersion aggregateSchemaVersion = this.versions.get(versionIndex);
            eventType = aggregateSchemaVersion.maybeRename(eventType);
            Optional<EventUpcaster> upcaster = aggregateSchemaVersion.findUpcaster(eventType);
            upcaster.ifPresent(upcasters::add);
            ++versionIndex;
        }
        return new NewEventNameAndUpcasters(eventType.equals(originalEventType) ? Optional.empty() : Optional.of(eventType), upcasters);
    }

    private String eventVersion(EventIdTypeAndData event) {
        Map map = event.getMetadata().map(md -> (Map)JSonMapper.fromJson((String)md, Map.class)).orElse(Collections.EMPTY_MAP);
        return (String)map.get("eventuate_schema_version");
    }

    private Optional<String> withNewVersion(Optional<String> metadata, String currentVersion) {
        Map map = metadata.map(md -> (Map)JSonMapper.fromJson((String)md, Map.class)).orElse(new HashMap());
        map.put("eventuate_schema_version", currentVersion);
        return Optional.of(JSonMapper.toJson((Object)map));
    }

    private boolean needsUpcast(String latestVersion, String actualVersion) {
        return !Objects.equals(latestVersion, actualVersion);
    }
}

