/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.commonimpl.common.schema;

import io.eventuate.javaclient.commonimpl.common.schema.AggregateSchemaVersion;
import io.eventuate.javaclient.commonimpl.common.schema.AggregateSchemaVersionBuilder;
import io.eventuate.javaclient.commonimpl.common.schema.ConfigurableEventSchema;
import io.eventuate.javaclient.commonimpl.common.schema.EventRename;
import io.eventuate.javaclient.commonimpl.common.schema.EventTransform;
import java.util.ArrayList;
import java.util.List;

public class AggregateSchemaBuilder {
    private final ConfigurableEventSchema configurableEventSchema;
    private final String aggregateType;
    private List<AggregateSchemaVersion> versions = new ArrayList<AggregateSchemaVersion>();

    public AggregateSchemaBuilder(ConfigurableEventSchema configuration, String aggregateType) {
        this.configurableEventSchema = configuration;
        this.aggregateType = aggregateType;
    }

    public AggregateSchemaVersionBuilder version(String version) {
        return new AggregateSchemaVersionBuilder(this, version);
    }

    protected void addVersion(String version, List<EventRename> renames, List<EventTransform> transforms) {
        this.versions.add(new AggregateSchemaVersion(version, renames, transforms));
    }

    public AggregateSchemaBuilder forAggregate(String aggregateType) {
        return this.configurableEventSchema.finishForAggregateAndStartNew(this.aggregateType, this.versions, aggregateType);
    }

    protected void build() {
        this.configurableEventSchema.finishForAggregateAndBuild(this.aggregateType, this.versions);
    }
}

