/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.commonimpl.common.schema;

import io.eventuate.javaclient.commonimpl.common.schema.AggregateSchemaBuilder;
import io.eventuate.javaclient.commonimpl.common.schema.EventRename;
import io.eventuate.javaclient.commonimpl.common.schema.EventTransform;
import io.eventuate.javaclient.commonimpl.common.schema.EventUpcaster;
import java.util.ArrayList;
import java.util.List;

public class AggregateSchemaVersionBuilder {
    private final AggregateSchemaBuilder aggregateSchemaBuilder;
    private final String version;
    private List<EventRename> renames = new ArrayList<EventRename>();
    private List<EventTransform> transforms = new ArrayList<EventTransform>();

    public AggregateSchemaVersionBuilder(AggregateSchemaBuilder aggregateSchemaBuilder, String version) {
        this.aggregateSchemaBuilder = aggregateSchemaBuilder;
        this.version = version;
    }

    public AggregateSchemaVersionBuilder rename(String oldEventName, String newEventName) {
        this.renames.add(new EventRename(oldEventName, newEventName));
        return this;
    }

    public AggregateSchemaVersionBuilder transform(String eventName, EventUpcaster upcaster) {
        this.transforms.add(new EventTransform(eventName, upcaster));
        return this;
    }

    public AggregateSchemaVersionBuilder version(String version) {
        this.finishForAggregate();
        return this.aggregateSchemaBuilder.version(version);
    }

    private void finishForAggregate() {
        this.aggregateSchemaBuilder.addVersion(this.version, this.renames, this.transforms);
    }

    public void customize() {
        this.finishForAggregate();
        this.aggregateSchemaBuilder.build();
    }

    public AggregateSchemaBuilder forAggregate(String account) {
        this.finishForAggregate();
        return this.aggregateSchemaBuilder.forAggregate(account);
    }
}

