/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.commonimpl.common.schema;

import io.eventuate.javaclient.commonimpl.common.EventIdTypeAndData;
import io.eventuate.javaclient.commonimpl.common.SerializedEvent;
import io.eventuate.javaclient.commonimpl.common.schema.AggregateSchema;
import io.eventuate.javaclient.commonimpl.common.schema.EventuateEventSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultEventuateEventSchemaManager
implements EventuateEventSchemaManager {
    public static final String SCHEMA_VERSION = "eventuate_schema_version";
    private Map<String, AggregateSchema> aggregateSchemaVersions = new HashMap<String, AggregateSchema>();

    public void add(AggregateSchema aggregateSchema) {
        if (this.aggregateSchemaVersions.containsKey(aggregateSchema.getAggregateType())) {
            throw new RuntimeException("Already defined: " + aggregateSchema.getAggregateType());
        }
        this.aggregateSchemaVersions.put(aggregateSchema.getAggregateType(), aggregateSchema);
    }

    public Optional<String> currentVersion(String aggregateClass) {
        return Optional.ofNullable(this.aggregateSchemaVersions.get(aggregateClass)).map(AggregateSchema::currentVersion);
    }

    @Override
    public Map<String, String> currentSchemaMetadata(String clasz) {
        return this.currentVersion(clasz).map(currentVersion -> Collections.singletonMap(SCHEMA_VERSION, currentVersion)).orElseGet(Collections::emptyMap);
    }

    @Override
    public List<EventIdTypeAndData> upcastEvents(String aggregateType, List<EventIdTypeAndData> events) {
        return Optional.ofNullable(this.aggregateSchemaVersions.get(aggregateType)).map(as -> as.upcastEvents(events)).orElse(events);
    }

    @Override
    public SerializedEvent upcastEvent(SerializedEvent se) {
        EventIdTypeAndData original = new EventIdTypeAndData(se.getId(), se.getEventType(), se.getEventData(), se.getMetadata() == null ? Optional.empty() : se.getMetadata());
        EventIdTypeAndData upcasted = this.upcastEvents(se.getEntityType(), Collections.singletonList(original)).get(0);
        SerializedEvent newSe = new SerializedEvent(se.getId(), se.getEntityId(), se.getEntityType(), upcasted.getEventData(), upcasted.getEventType(), se.getSwimLane(), se.getOffset(), se.getEventContext(), upcasted.getMetadata());
        return newSe;
    }
}

